/*
 * Decompiled with CFR 0.152.
 */
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.TreeMap;
import java.util.Vector;

public class AgentServer
implements Runnable {
    private Vector<String> linkVector = new Vector();
    private TreeMap<String, String> visitedMap = null;
    public static final int PORT = 3030;
    public static final String HOST = "localhost";
    public static final String VERSION = "1.0.0";

    public AgentServer() {
        this.linkVector.add("127.0.0.1");
        this.visitedMap = new TreeMap();
    }

    public void sendAgent(String string, int n, String string2, byte[] byArray) {
        try {
            Socket socket = new Socket(string, n);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
            objectOutputStream.writeObject(string2);
            objectOutputStream.writeObject(byArray);
            objectOutputStream.flush();
            objectOutputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Agent readAgent(Socket socket) {
        Agent agent;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
            String string = (String)objectInputStream.readObject();
            byte[] byArray = (byte[])objectInputStream.readObject();
            socket.close();
            ServerClassLoader serverClassLoader = new ServerClassLoader(string, byArray);
            Class clazz = serverClassLoader.findClass(string);
            agent = (Agent)clazz.newInstance();
            String string2 = this.visitedMap.get(string);
            if (string2 == null) {
                this.visitedMap.put(string, "true");
                new ConnectThread(this.linkVector, 3030, string, byArray).start();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            agent = null;
        }
        return agent;
    }

    @Override
    public void run() {
        System.out.println(">>>Roaming Agents Server: 1.0.0");
        System.out.println("Author: Matthew W. Coan");
        System.out.println("URL: http://slack.net/~mcoan/");
        System.out.println("Email: matthewcoan@hotmail.com");
        System.out.println();
        System.out.println("port number = 3030");
        try {
            Socket socket;
            ServerSocket serverSocket = new ServerSocket(3030, 1024, InetAddress.getByName(HOST));
            System.out.println("server socket...");
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            System.out.println("server running...");
            while ((socket = serverSocket.accept()) != null) {
                System.out.println("accept connection...");
                Agent agent = this.readAgent(socket);
                if (agent != null) {
                    new AgentThread(agent, treeMap).start();
                }
                System.out.println("accept next...");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        AgentServer agentServer = new AgentServer();
        agentServer.run();
    }

    class ConnectThread
    extends Thread {
        Vector<String> linkVector;
        byte[] data;
        String className;
        int port;

        ConnectThread(Vector<String> vector, int n, String string, byte[] byArray) {
            this.linkVector = vector;
            this.data = byArray;
            this.className = string;
            this.port = n;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.linkVector.size(); ++i) {
                AgentServer.this.sendAgent(this.linkVector.get(i), this.port, this.className, this.data);
            }
        }
    }
}

