#include <iostream>
#include <fstream>
#include <string>
#include <map>
#include <sys/types.h>
#include <signal.h>
#include <unistd.h>

using namespace std;

int task_count = 0;

enum { MAX_FORK = 30 };
enum { SMB_TIMEOUT = 20 };

#define SCRIPT_DIR "/home/mcoan/backup_script/script.txt"
#define REMOTE_HOST "//192.168.1.2/pub"

int
System(const string & cmd)
{
   cout << cmd << endl;
   return system(cmd.c_str());
}

void
on_SIGALRM(int sig)
{
   cout << "SIGALRM...\n" << flush;
   exit(0);
}

string
to_samba(const string & str)
{
   string ret;
   for(size_t i = 0; i < str.size(); i++) {
      if(str[i] == '/') {
         ret += "\\";
      }
      else {
         ret += str[i];
      }
   }
   return ret;
}

int
GetFile(const string & file, 
        const string & linux_dir, 
        const string & freebsd_dir)
{
   cout << "GetFile(" << file 
        << ", " << linux_dir << ", " 
        << freebsd_dir << ")" << endl;
/*
   task_count++;
   if(task_count >= MAX_FORK) {
      cout << "SLEEP...\n" << flush;
      sleep(1000 * 3);
      task_count = 0;
   }
*/
   //if(fork() == 0) {
      //signal(SIGALRM, on_SIGALRM);
      //alarm(SMB_TIMEOUT);
      ofstream fout("/home/mcoan/linux_backup/script.txt", ios::out | ios::ate | ios::trunc);
      if(fout) {
         fout << "cd " << linux_dir << endl;
         fout << "get " << file << endl;
         fout.close();
      }
      if(System("cd " + freebsd_dir + " ; cat " + string(SCRIPT_DIR) 
                + "/script.txt | smbclient //" + string(REMOTE_HOST) + " -U \"Guest%\"") == 0) {
         cout << "OK...\n" << flush;
      }
      //alarm(0);
   //}
   return 0;
}

void on_SIGCHLD(int sig)
{
   cout << "SIGCHLD...\n" << flush;
   task_count--;
}

int
main()
{
   signal(SIGCHLD, on_SIGCHLD);
   map< string, bool > is_dir;
   {
      ifstream fin("filelist.txt", ios::in);
      if(fin) {
         string line;
         while(fin >> line) {
            if(line.find(":") != string::npos) {
               line = "" + line.substr(0,line.size()-1);
               is_dir[line] = true;
            }
         }
         fin.close();
      }
   }
   ifstream fin("filelist.txt", ios::in);
   if(fin) {
      string line,file,dir,dir2;
      while(fin >> line) {
         if(line.find(":") == string::npos && line.size() != 0) {
            file = line;
            if(is_dir.find(dir + "/" + file) != is_dir.end())
               continue;
            line = "/home/mcoan/linux_backup" + dir2 + "/"/* + file*/;
            if(GetFile(file, dir, line) == 0) {
               cout << "GetFile running...\n" << endl;
               line = "";
               file = "";
            } 
            else {
               cerr << "scp error..." << endl;
               break;
            }
         }
         else if(line.find(":") != string::npos) {
            dir = "" + line.substr(0, line.size()-1);
            dir2 = "/" + line.substr(0, line.size()-1);
         }
      }
      fin.close();
   }
   return 0;
}
