#include <time.h>

#include <iostream>
#include <fstream>
#include <string>

#define __WIN32__

#include "MultipartRequest.h"
#include "csv.h"

#include "bbs.h"
#include "config.h"

using namespace std;
using namespace csv_reader;

#define BBS_VERSION "V1.0.0"

void
copy_file(const string & f1,
          const string & f2)
{
   ifstream fin(f1,ios::in|ios::binary);
   ofstream fout(f2,ios::out|ios::ate|ios::trunc|ios::binary);
   if(!fin.fail() && !fout.fail()) {
      char ch;
      ch = fin.get();
      while(!fin.eof()) {
         fout << ch << flush;
         ch = fin.get();
      }
   }
}

int
System(const string & cmd) 
{
   return system(cmd.c_str());
}

string
shellescape(const string & str)
{
   string ret;
   for(size_t i = 0; i < str.size(); i++) {
      if(str[i] == '\r')
         ret += "\\r";
      else if(str[i] == '\n')
         ret += "\\n";
      else if(str[i] == '\t')
         ret += "\\t";
      else if(str[i] == '\"')
         ret += "\\\"";
      else
         ret += str[i];
   }
   return ret;
}

/*
bool
copy_file(const string & infile,
          const string & outfile)
{
//cout << "INFILE: [" << infile << "]<BR>" << endl << flush;
//cout << "OUTFILE: [" << outfile << "]<BR>" << endl << flush;
   ofstream out(outfile.c_str(), ios::ate | ios::trunc | ios::out);
   ifstream in(infile.c_str(), ios::in);
   if(!out || !in) return false;
   char ch;
   int count = 0;
   ch = in.get();
   while(in) {
      out << ch;
      count++;
      if((count % 1024) == 0)
         out << flush;
      ch = in.get();
   }
   out << flush;
   in.close();
   out.close();
   return true;
}
*/


bool
ends_with(const string & file_name,
          const string & filter)
{
   size_t size = filter.size()+1;
   char * buffer = new char[size];
   memset(buffer, 0, size);
   strcpy(buffer, filter.c_str());
   char * ptr = strtok(buffer, "|");
   size_t len;
   bool ret = false;
   while(ptr) {
      len = strlen(ptr);

      if(len < file_name.size()) {
         if(strncmp(file_name.c_str()+file_name.size()-len, ptr, len) == 0) {
            ret = true;
            break;
         }
      }

      ptr = strtok(NULL, "|");
   }
   delete [] buffer;
   return ret;
}


int
BBS::process_request(MultipartRequest & req) 
{
   //cout << "Content-type: text/html\r\n\r\n" << flush;

   int ret = 0;

   ofstream out(FILE_LIST, ios::app | ios::out | ios::ate);

   if(out) {
      time_t clock = time(NULL);
      string date = ctime(&clock);
      MultipartRequest::FormElement * name;
      MultipartRequest::FormElement * email;
      MultipartRequest::FormElement * desc;
      MultipartRequest::FormElement * data_file;
      MultipartRequest::FormElement * url;

      name = req["name"];
      email = req["email"];
      desc = req["desc"];
      data_file = req["dataFile"];
      url = req["url"];

      if(name && email && desc && data_file && url) {
         if(data_file->length() != 0) { 
            if(ends_with(data_file->fileName(), ".dll|.bat|.zip|.tar.gz|.bz2|.java|.jar|.txt|.cpp|.h|.c|.cc|.cxx|.C|.s|.pl|.asm|.p|.bas")) {
               out << "\"" << (name->data()) << "\",\"" << date << "\",\"" 
                   << (email->data()) << "\",\"" << (url->data()) << "\",\"" << (desc->data()) << "\",\""
                   << (data_file->localFileName()) << "\",\""
                   << (data_file->length()) << "\"" << endl << flush;
               copy_file(data_file->localFileName(), string(LIVE_DIR) + data_file->fileName());
            }
            else {
               unlink(data_file->localFileName());
               ret = 1;
            }
         }
         else {
            ret = 1;
         }
      }
      else {
         ret = 1;
      }

      out.close();
   }
   else {
      ret = 1;
   }

   if(ret == 0) {
      cout << "Location: /upload.asp\r\n\r\n" << flush;
   }
   else {
      cout << "Location: /error.asp\r\n\r\n" << flush;
   }

   return ret;
}

string
to_file_name(const string & str)
{
   string ret;

   const char * p = strrchr(str.c_str(), '\\');

   if(p) {
      p++;

      ret = string(p);
   }

   return ret;
}

//
// Simple program to test the MultipartRequest class.
//
// Author:	Matthew W. Coan
// Date:	April 14, 2002
//
int
main()
{
	//cout << "Content-type: text/html\r\n\r\n" << endl;

   int ret = 0;

   const char * method = getenv("REQUEST_METHOD");

   if(method == NULL) {
      method = "POST";
   }

   if(strcmp(method, "GET") == 0) {
      csv_row_type csv_row;

      ifstream in(FILE_LIST, ios::in);

      if(in) {
         cout << "Content-type: text/html\r\n\r\n" << endl;

         cout << "<HTML>" << endl;
         cout << "<HEAD>" << endl;
         cout << "<TITLE>Bulliten Board Service " << BBS_VERSION << "</TITLE>" << endl;
         cout << "</HEAD>" << endl;
         cout << "<BODY BGCOLOR=\"WHITE\">" << endl << flush;
         cout << "&nbsp;<B>Bulliten Board Service " << BBS_VERSION << "...</B><BR><BR>" << endl;
         cout << "&nbsp;<A HREF=\"/bbs.html\">Upload a file...</A><BR>" << flush;
         cout << "<BR><HR><BR>" << endl;
         cout << "&nbsp;<TABLE BORDER=\"1\">" << endl << flush;
         cout << "<TR><TD>File Name</TD><TD>Date</TD>"
               << "<TD>Description</TD><TD>Size</TD>";
         cout << "<TD>What is in the file?</TD>" << endl << flush;
         cout << "</TR>" << endl << flush;

         while(in >> csv_row) {
            cout << "<TR>" << endl << flush;

            if(csv_row.size() >= 6) {
               string temp = csv_row[5];
#ifndef __WIN32__
               if(ends_with(temp, ".dll|.h|.c|.cpp|.asm|.lis|.bas|.pro|.js")) {
                  cout << "<TD><A HREF=\"/~mcoan/cgi-bin/cxx_browser.cgi?infile=file_upload/" << (to_file_name(csv_row[5])) << "\">" 
                        << to_file_name(csv_row[5]) << "</A></TD>" << endl << flush;
               }
               else {
#endif
                  //cout << "<TD><A HREF=\"/scripts/bbs_view.exe?file=" << (to_file_name(csv_row[5])) << "\">" 
                  cout << "<TD><A HREF=\"/files/" << (to_file_name(csv_row[5])) << "\">" 
                        << to_file_name(csv_row[5]) << "</A></TD>" << endl << flush;
#ifndef __WIN32__
               }
#endif
               cout << "<TD>" << csv_row[1] << "</TD>" << endl << flush;
               cout << "<TD>" << csv_row[4] << "</TD>" << endl << flush;
               cout << "<TD ALIGN=\"RIGHT\">" << csv_row[6] << " bytes</TD>" << endl << flush;
               cout << "<TD>" << endl;
               //cout << "<PRE>" << endl;
//#ifdef HAVE_FILE
               //System(string("java -jar c:\\development\\shell\\file\\tika-app-2.4.0.jar --detect \"") + csv_row[5]
               System(string("c:\\development\\shell\\file.exe \"") + string(LIVE_DIR) + to_file_name(csv_row[5])
                     + string("\" > ") + string(CGI_ROOT) + string("file_temp.txt"));
               ifstream fin((string(CGI_ROOT) + "file_temp.txt").c_str(), ios::in);
               if(fin) {
                  char ch = fin.get();
                  string buffer;
                  while(fin) {
                     buffer += ch;
                     ch = fin.get();
                  } 
                  fin.close(); 
                  string::size_type p;
                  if((p=buffer.rfind(":")) != string::npos) {
                     buffer = buffer.substr(p+1);
                  }
                  cout << buffer << endl << flush;
               }
//#endif
               //cout << "</PRE>" << endl;
               cout << "</TD>" << endl << flush;
            }
      
            cout << "</TR>" << endl << flush;
         }

         in.close();

         cout << "</TABLE>" << endl << flush;
         cout << "</BODY>" << endl << flush;
         cout << "</HTML>" << endl << flush;
      }
   }
   else {
	   MultipartRequest req(FILE_DIR);
	
  	   if(req.errorCode() == MultipartRequest::NO_ERROR) {
         BBS bbs;
         ret = bbs.process_request(req);
	   }
	   else {
         switch(req.errorCode()) {
            case MultipartRequest::IO_ERROR:     // I/O error occured
               fprintf(stdout, "IO_ERROR");
               fflush(stdout);
               break;
            case MultipartRequest::PARSE_ERROR:  // Multipar request parse error
               fprintf(stdout, "PARSE_ERROR");
               fflush(stdout);
               break;
            case MultipartRequest::MAX_UPLOAD:   // Maximum file upload size
               fprintf(stdout, "MAX_UPLOAD");
               fflush(stdout);
               break;
            case MultipartRequest::CGI_ERROR:    // CGI error
               fprintf(stdout, "CGI_ERROR");
               fflush(stdout);
               break;
            case MultipartRequest::NO_ERROR:
               fprintf(stdout, "NO_ERROR");
               fflush(stdout);
               break;
         }
      }
	}

	return 0;
}

