#ifndef _REF_H
template< class T >
class REF {
public:
	T* ptr;
	size_t ref_count;
	REF(T* ptr) {
		this->ptr = ptr;
		ref_count = 0;
	}
	REF & operator=(const REF & ref) {
		ptr = ref.ptr;
		ref_count = ref.ref_count;
	}
};

template< class T >
class Ref {
	REF< T >* ref;
	void dec() {
		ref->ref_count--;
		if(ref->ref_count == 0) {
			if(ref->ptr) {
				delete ref->ptr;
				ref->ptr = 0;
			}
		}
	}
	void inc() {
		ref->ref_count++;
	}
public:
   Ref(T val) {
		ref = new REF(new T(val));
	}
	Ref(const T * obj) {
		ref = new REF(obj);
		inc();
	}
	Ref(const Ref< T > & copy) {
		ref = copy.ref;
		inc();
	}
	~Ref() {
		dec();
      delete ref;
	}
	Ref< T > & operator=(const Ref< T > & copy) {
		dec();
		ref = copy.ref;
		inc();
		return *this;
	}
	Ref< T > & operator=(T* copy) {
		dec();
		ref = new REF(copy);
		inc();
		return *this;
	}
	T* operator->() {
		return ref->ptr;
	}
	const T* operator->() const {
		return ref->ptr;
	}
	const T & operator*() const {
		return *(ref->ptr);
	}
	T* get_ptr() {
		return ref->ptr;
	}
	operator T *() {
		return ref->ptr;
	}
};

#endif