import java.io.*;
import java.net.*;

public class wiki extends libc {
   public static void main(String args[]) {
       wiki wi = new wiki();
       wi.run(args);
   }
   public String my_encode(String text) {
      String ret = new String();
      for(int i = 0; i < text.length(); i++) {
         if(text.charAt(i) == ' ') {
            ret += "_";
         }
         else {
            ret += text.charAt(i); 
         }
      }
      return ret;
   }
   public boolean isPunct(char ch) {
      String pun = "()[]#$%!.?-_/\\|{}*&^@~;:,<>";
      return pun.indexOf(ch) >= 0;
   }
   public void run(String args[]) {
      try {
         if(args.length < 1) {
            perror("usage: wiki <phrase>\n");
            exit(1);
         }
         String text = "";
         for(int i = 0; i < args.length; i++) {
            if(text.length() != 0) {
               text += " ";
            }
            text += args[i];
         }
         //URL url = new URL("https://en.wikipedia.org/w/api.php?action=query&format=json&titles=" 
         //                  + URLEncoder.encode(my_encode(text)) + "&prop=extracts&exintro&explaintext&format=xml");
         URL url = new URL("https://en.wikipedia.org/w/api.php?action=query&list=search&srsearch=" 
                           + URLEncoder.encode(text) + "&format=xml");
         Object obj = url.getContent();
         if(obj instanceof InputStream) {
            InputStream in = (InputStream)obj;
            String buf = new String();
            int ch = in.read();
            while(ch != -1) {
               buf += ((char)ch);
               ch = in.read();
            }
            int index = buf.indexOf("snippet=\"");
            String temp = new String();
            while(index != -1) {
               index += 9;
               for(int i = index; buf.charAt(i) != '\"'; i++) {
                  temp += buf.charAt(i);
               }   
               temp += "\n";
               index = buf.indexOf("snippet=\"",index);
            }
            buf = temp;
            buf = buf.replace("&lt;", "<");
            buf = buf.replace("&gt;", ">");
            buf = buf.replace("&quot;", "\"");
            buf = buf.replace("&amp;", "&");
            buf = buf.replace("&nbsp;", "&");
            temp = new String();
            boolean in_tag = true;
            for(int i = 0; i < buf.length(); i++) {
               if(buf.charAt(i) == '<' && !in_tag) {
                  in_tag = true;
               }
               else if(buf.charAt(i) == '>' && in_tag) {
                  in_tag = false;
               }
               else if(!in_tag) {
                  temp += buf.charAt(i);
               }
            }
            buf = temp;
            buf = buf.replace("&lt;", "<");
            buf = buf.replace("&gt;", ">");
            buf = buf.replace("&quot;", "\"");
            buf = buf.replace("&amp;", "&");
            buf = buf.replace("&nbsp;", " ");
            temp = new String();
            for(int i = 0; i < buf.length(); i++) {
               if(Character.isDigit(buf.charAt(i))) {
                  temp += buf.charAt(i);
               }
               else if(Character.isLetter(buf.charAt(i))) {
                  temp += buf.charAt(i);
               }
               else if(Character.isSpace(buf.charAt(i))) {
                  temp += buf.charAt(i);
               }
               else if(isPunct(buf.charAt(i))) {
                  temp += buf.charAt(i);
               }
            }
            printf(temp);
         }
         else if(obj instanceof String) {
            printf(obj.toString()+"\n");
         }
      }
      catch(Exception ex) {
         perror("wiki client error...\n");
         exit(1);
      }
   }
}
