#include <iostream>
#include <fstream>
#include <string>
#include <cstring>

using namespace std;

#ifdef NO_MAIN
extern "C" {
extern int write_md5_main(int argc, char ** argv);
}
int write_md5_main(int argc, char ** argv)
#else
int main(int argc, char ** argv)
#endif
{
   if(argc != 3) {
      cerr << "usage: " << argv[0] << " <exe> <message_digest>" << endl;
      return -1; 
   }
   ifstream fin(argv[2]);
   string hash;
   if(!fin.fail()) {
      fin >> hash;
      fin.close();
   }
   fstream bin(argv[1], ios::binary | ios::in | ios::out);
   if(!bin.fail()) {
      bin.seekg(0L, ios::end);
      size_t size = (size_t)bin.tellg();
      char * file = new char [size];
      bin.seekg(0L, ios::beg);
      bin.read(file, size); 
      size_t i = 0; 
      bool found = false;
      for(char * ptr = file; i < (size-8); i++, ptr++) {
         if(memcmp(ptr, "$start$0", 8) == 0) {
            ptr += 7;
            for(size_t j = 0; j < hash.size(); j++) {
               ptr[j] = hash[j];
            }
            found = true;
            break;
         }
      }
      bin.seekg(0L, ios::beg);
      bin.write(file, size);
      bin.close();
      delete [] file; 
      if(!found) {
         cerr << "The message digest not written to the \"" 
              << argv[1] << "\" file..." << endl;
      }
   }
   return 0;
}
