#ifndef CLIST_H
#define CLIST_H

#include <assert.h>
#include <stdlib.h>

/**
 * ANSI C implementation of a circular doubly linked list.
 *
 * Matthew W. Coan (11/3/97) Orases Corp.
 */


/************************************
 * The node structure type definiton.
 */
typedef struct _CListNode {

   struct _CListNode * next;
   struct _CListNode * prev;
   void * data;

} CListNode;

/*---------------------------------
  Functions that act on list nodes.
  -------------------------------*/

/* Create node operation. */

CListNode * CListNodeCreate ( void * , CListNode * , CListNode * );

/* Destroy node operation. */
void CListNodeDestroy ( CListNode * , void ( * ) ( void * ) );



/*************************************
 * The list structure type definition.
 */
typedef struct _CList {

   CListNode * head;
   unsigned long size;
   void ( * pDestroyData ) ( void * );

} CList;

/*-------------------------------------------------------------------------------
  The lib. of functions and macrows suporting the CList type defined C structure.
  -----------------------------------------------------------------------------*/

/* Retreve the size of the list. */
#define CListSize(pList)	(pList->size)

/* Retreve the data at the tail of the list. */
#define CListTail(pList)	(pList->head->prev->data)

/* Retreve the data at the head of the list. */
#define CListHead(pList)	(pList->head->next->data)

/* A check to see if the list is empty. */
#define CListIsEmpty(pList)	(pList->size == 0)

/* Retreve a pointer to the begining of the list. */
#define CListBegin(pList)	(pList->head->next)

/* Retreve a pointer to the first node at the end of the list. */
#define CListRBegin(pList)	(pList->head->prev)

/* Retreve a pointer to the end of the list. */
#define CListEnd(pList)		(pList->head)

/* Construct operation. */
CList * CListCreate ( void ( * ) ( void * ) );

/* List destory operation. */
void CListDestroy ( CList * );

/* Clear all nodes operation. */
void CListClear ( CList * );

/* Push an element on the head of a list. */
void CListPushHead ( CList * , void * );

/* Push an element on the tail of a list. */
void CListPushTail ( CList * , void * );

/* Remove the head of the list. */
void CListPopHead ( CList * );

/* Remove the tail of the list. */
void CListPopTail ( CList * );

/* Apply a function to every data pointer in a list from */
/* the head to the tail. */
void CListForEachHtoT ( CList * , void ( * ) ( void * ) );

/* Apply a function to every data pointer in a list from */
/* the tail to the head. */
void CListForEachTtoH ( CList * , void ( * ) ( void * ) );

#endif /* End of CLIST_H. */

