#ifndef _STR_H
#define _STR_H

#include <string>
#include <sstream>
#include <cctype>

namespace string_tools {

using namespace std;

class str_exception {
   const char * message;

public:
   str_exception(const char * message) {
      this->message = message;
   }

   const char * get_message() const {  
      return message;
   }
};

inline
string replace(const string & buffer, const string & str, const string & rep)
{
   string ret = buffer;
   string::size_type p;

   while((p=ret.find(str)) != string::npos) {
      ret = ret.substr(0, p) + rep + ret.substr(p+str.size());
   }

   return ret;
}

template< class T >
inline
string to_string(const T & t)
{
   stringstream ss;
   ss << t;
   string temp;
   ss >> temp;
   return temp;
}

inline
long to_long(const string & temp)
{
   return atol(temp.c_str());
}

inline
double to_double(const string & temp)
{
   return atof(temp.c_str());
}

inline
bool to_bool(const string & temp) 
{
   bool ret;
   if(temp == "true") 
      ret = true;
   else if(temp == "false")
      ret = false;
   else 
      throw str_exception("can't convert to bool data type...");
   return ret;
}

inline
bool ends_with(const string & str, const string & end) {
   bool ret = false;
   string::size_type ptr = str.rfind(end);
   if(ptr != string::npos) {
      string temp = str.substr(ptr);
      if(temp == end) {
         ret = true;
      }
   }
   return ret;
}

inline
bool starts_with(const string & str, const string & end) {
   bool ret = false;
   if(str.find(end) == 0) {
      ret = true;
   }
   return ret;
}

inline
string trim(const string & str)
{
   string ret,temp;
   stringstream s;
   s << str;
   while(s >> temp) {
      if(ret.size() && temp != ",") 
         ret += " ";
      ret += temp;
   }
   return ret;
}

template< class T >
inline
string to_hex(const T & val)
{
   stringstream s;
   s << hex << val;
   string ret;
   s >> ret;
   return ret;
}

inline
string url_escape(const string & str)
{
   string ret;
   stringstream s;
   for(size_t i = 0; i < str.size(); i++) {
      if(str[i] == ' ') 
         s <<  "+";
      else
         s << "%" << hex << str[i];
   }
   ret = s.str();
   return ret;
}

inline
string strip_html(const string & html) {
   string ret;
   bool in = false;
   for(size_t i = 0; i < html.size(); i++) {
      if(html[i] == '<') 
         in = true;
      else if(html[i] == '>') {
         in = false;
         ret += ' ';
         continue;
      }
      if(!in) {
         ret += html[i];
      }
   }
   return ret;
}

inline
string to_lower(const string & str) 
{
   string ret;
   for(size_t i = 0; i < str.size(); i++) {
     ret += tolower(str[i]);
   }
   return ret;
}

inline
string csv_escape(const string & str) 
{
   string ret;
   for(size_t i = 0; i < str.size(); i++) {
      if(str[i] == '\"') {
         ret += "\"\"";
      }
      else {
         ret += str[i];
      }
   }
   return ret;
}

inline
string clean_text(const string & str) {
   string ret;
   for(size_t i = 0; i < str.size(); i++) {
      if(ispunct(str[i]) || isalnum(str[i]) || isspace(str[i])) {
         ret += str[i];
      }
   }
   return ret;
}

inline
bool is_digit(char ch)
{
   bool ret = false;
   const char * table = "0123456789";
   if(strchr(table, ch) != 0) 
      ret = true;
   return ret;
}

inline
bool is_int(const string & str)
{
   bool ret = false;
   for(size_t i = 0; i < str.size(); i++) {
      if(is_digit(str[i])) {
         ret = true;
      }
      else {
         ret = false;
         break;
      }
   }
   return ret;
}

inline
bool is_float(const string & str)
{
   bool ret = false;
   for(size_t i = 0; i < str.size(); i++) {
      if(is_digit(str[i]) || str[i] == '.') {
         ret = true;
      }
      else {
         ret = false;
         break;
      }
   }
   return ret;
}



}


#endif /* _STR_H */
