#ifndef _HTML_H
#define _HTML_H

#include <fstream>
#include <iostream>
#include <sstream>
#include <vector>
#include <string>

namespace cgi_tools {

using namespace std;

typedef vector< string > string_vector_type;

class html {
   string_vector_type html_text;

public:
   html();

   html(const string & file_name);

   html(const html & cp);

   html(const string & file_name);

   ~html();

   html & operator=(const html & cp);

   void set_html(const string & ht);

   string to_string();

   bool extract(const string & start, const string & end, html & ht);

   void expand(const string & start, const string & end, const html & ht);
  
   void expand(const string & name, const string & value);

   void expand(const string & name, const html & ht);

   ostream & operator<<(ostream & out);

   istream & operator>>(istream & in);

   html & operator<<(const char * str);

   html & operator<<(const string & str);
   
   html & operator<<(const char ch);

   html & operator<<(const short sh);

   html & operator<<(const int ival);

   html & operator<<(const float fval);
 
   html & operator<<(const double & dval);

   html & operator<<(const long & lval);

   html & operator<<(const unsigned char ch);

   html & operator<<(const unsigned short sh);

   html & operator<<(const unsigned int ival);

   html & operator<<(const unsigned long lval);

   html & operator<<(const html & ht);
};

}

#endif /* _HTML_H */
