/*

(C) Copyright 2011.  All rights reserved.
This source code is the intellectual property of Matthew William Coan.

HTTP Session CRON job...

Author: Matthew W. Coan
Date: Sun Jun  5 18:18:04 EST 2011

*/

#include <list>
#include <iostream>
#include <fstream>
#include <time.h>
#include <unistd.h>

#include "csv.h"
#include "lock_file.h"

using namespace std;
using namespace csv_reader;
using namespace file_tools;

typedef list< csv_row_type > session_list_type;

#define SESSION_FILE "/home/mcoan/session/session.csv"
#define SESSION_LOCK "/home/mcoan/session/session.lock"
#define TIMEOUT_LENGTH (60 * 60)

int
main(int argc,
     char ** argv,
     char ** envp)
{
   int ret = 0;

   csv_row_type row;
   csv_row_map_type row_map;
   string last_mod_str;
   time_t last_mod;
   session_list_type the_list;

   LockFile lock_file(SESSION_LOCK);


   lock_file.write_lock();

   ifstream fin(SESSION_FILE, ios::in);

   if(fin) {
      fin >> row;

      if(fin) {
         map_row(row, row_map);

         while(fin >> row) {
            last_mod_str = row[row_map["last_mod"]];

            last_mod = atoi(last_mod_str.c_str());

            if(last_mod < (time(NULL) - TIMEOUT_LENGTH)) {
               the_list.push_back(row);
            }
            else {
               unlink(row[row_map["file_name"]].c_str());
            }
         }
      }

      fin.close();

      fstream fout(SESSION_FILE, ios::out | ios::trunc);

      if(fout) {
         fout << "\"key\",\"file_name\",\"last_mod\"" << endl << flush;
         for(session_list_type::iterator ptr = the_list.begin(); ptr != the_list.end(); ptr++) {
            fout << "\"" << row[row_map["key"]] << "\",\"" 
                 << row[row_map["file_name"]] << "\",\"" 
                 << row[row_map["last_mod"]] << "\"" << endl << flush;
         }

         fout.close();
      }
   }

   lock_file.write_unlock();

   return ret;
}
