#include "cgid.h"

/*

Copyright (C) 2011.  All rights reserved.
This software is the intellectual property of Matthew William Coan.


Author: Matthew William Coan
Date: 

*/

#include "cgid.h"

using namespace cgid;

#define OS_WINDOWS
//#define OS_UNIX

#ifdef OS_WINDOWS
#include <windows.h>

WSADATA stWSAData;  // WinSock DLL Info.

#define WSA_MAJOR_VERSION 1
#define WSA_MINOR_VERSION 1
#define WSA_VERSION MAKEWORD(WSA_MAJOR_VERSION, WSA_MINOR_VERSION)

#endif 

extern "C" {
   extern int server_main();
}

//int
//server_main()

#ifdef OS_WINDOWS
int WINAPI 
WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
#endif
#ifdef OS_UNIX
int
main(int argc, char ** argv, char ** envp)
#endif
{
#ifdef OS_WINDOWS
   WSAStartup(WSA_VERSION, &stWSAData);
#endif

   bool daemon_flag = false;

#ifdef OS_UNIX
   if(argc == 2) {
      if(strcmp(argv[1], "-d") == 0) {
         daemon_flag = true;
      }
      else if(strcmp(argv[1], "-h") == 0) {
         cout << "usage: " << argv[0] << " [-d|-h]" << endl << flush;
         cout << "-d run as daemon" << endl << flush;
         cout << "-h this help message" << endl << flush;
         exit(0);
      }
   }
#endif

   CGID the_cgid("127.0.0.1", 1995, daemon_flag);

   cout << "run next..." << endl << flush;

   the_cgid.run();

   cout << "done..." << endl << flush;

   return 0;
}
