/*

DLL file class for Windows, Linux and BSD.

Author: Matthew William Coan
Date: Fri Jan  7 20:50:58 EST 2011

*/

#ifndef _DLL_FILE_H
#define _DLL_FILE_H

#include <string>

//#include <dlfcn.h>
//#include "dlfcn.h"
#include <windows.h>

using namespace std;

extern "C" {
typedef void * (*pf_t)();
extern pf_t get_proc_address(HINSTANCE h, const char * name);
}

class dll_file {
   HINSTANCE _pointer;

public:
   dll_file(const char * str) {
      //_pointer = dlopen(str, RTLD_LAZY);
      _pointer = LoadLibrary(str);
      if(_pointer == 0) {
         cerr << "unable to open a lib: " << str << endl;
      }
   }

   ~dll_file() {
      if(_pointer) {
         CloseHandle(_pointer);
         //dlclose(_pointer);
      }
   }

   void close() {
      if(_pointer) {
         CloseHandle(_pointer);
         //dlclose(_pointer);
         _pointer = 0;
      }
   }

   operator void*() {
      return _pointer;
   }

   pf_t get_symbol(const char * symbol) {
      return get_proc_address(_pointer, symbol);
      //return dlsym(_pointer, symbol);
   }
};

#endif /* _DLL_FILE_H */
