/*

CGILet class for the cgid server...

Author: Matthew W. Coan
Date: Fri Sep 30 04:17:12 EDT 2011

*/
#ifndef _CGILET_H
#define _CGILET_H

#include <map>
#include <vector>
#include <string>

#include "tcp_stream.h"
#include "sql.h"

namespace cgid {

using namespace std;
using namespace net_tools;
using namespace sql_client;

class FormData {
public:
   typedef vector< string > string_vector_type;
   typedef map< string, string_vector_type > string_vector_map_type;

private:
   string_vector_map_type _form_data;

public:
    string_vector_type get_values(const string & param) { return _form_data[param]; }
    bool has_param(const string & param) { return _form_data.find(param) != _form_data.end(); }
    string get_value(const string & param) { 
       string ret;
       if(_form_data[param].size()) {
          ret = _form_data[param].front(); 
       }
       return ret;
    }
    void put(const string & name, const string & value) {
       _form_data[name].push_back(value);
    }
    string operator[](const string & key) {
       return get_value(key); 
    }
};

class CGILet {
public:
   CGILet() { }
   virtual ~CGILet() { }

   virtual void process_request(tcp_stream & out, FormData & form_data, Connection * conn) { }
   virtual void process_request(tcp_stream & out, FormData & form_data) { }
};

}

#endif /* _CGILET_H */
