#include "stdafx.h"

/*

Copyright (C) 2011.  All rights reserved.
This software is the intellectual property of Matthew William Coan.


Author: Matthew William Coan
Date: 

*/

#include "cgid.h"

using namespace cgid;

WSADATA stWSAData;  // WinSock DLL Info.

#define WSA_MAJOR_VERSION 1
#define WSA_MINOR_VERSION 1
#define WSA_VERSION MAKEWORD(WSA_MAJOR_VERSION, WSA_MINOR_VERSION)

int
main(int argc, char ** argv, char ** envp)
{
   WSAStartup(WSA_VERSION, &stWSAData);

   bool daemon_flag = false;

   if(argc == 2) {
      if(strcmp(argv[1], "-d") == 0) {
         daemon_flag = true;
      }
      else if(strcmp(argv[1], "-h") == 0) {
         cout << "usage: " << argv[0] << " [-d|-h]" << endl << flush;
         cout << "-d run as daemon" << endl << flush;
         cout << "-h this help message" << endl << flush;
         exit(0);
      }
   }

   CGID the_cgid("127.0.0.1", 1995, daemon_flag);

   cout << "run next..." << endl << flush;

   the_cgid.run();

   cout << "done..." << endl << flush;

   return 0;
}
