/*

    Copyright (C) 2009  Matthew William Coan

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.


 THE C++ COMPILER DRIVER PROGRAM...

 AUTHOR: MATTHEW WILLIAM COAN
 DATE: Sun Sep  5 22:26:48 EDT 2010


*/

#include <iostream>

#include <string>
#include <vector>

#include <cstdlib>
#include <cstring>

#include <signal.h>
#include <sys/types.h>

using namespace std;

// comment out to take away debug code
#define DEBUG_CODE_CXX

#define CPP_CMD		"/usr/bin/cpp"
#define CC_CMD		"./cc"
#define ASM_CMD		"nasm"
#define LINK_CMD	"/usr/bin/cc"
#define STRIP_CMD	"/usr/bin/strip"
#define CP_CMD		"/bin/cp"

inline
string
get_file_name(const string & file_name)
{
   string ret;
   char * buffer;

   buffer = new char[file_name.size()+1];
  
   memset(buffer, 0, file_name.size()+1);

   strcpy(buffer, file_name.c_str());

   char * ptr = strrchr(buffer, '.');

   if(ptr != NULL) {
      const char * p = buffer;
      while(p != ptr) {
         ret += (*p);
         p++;
      }
   }

   delete [] buffer;

   return ret;
}

typedef vector< string > string_vector_type;

inline
int
System(const string & cmd)
{
#ifdef DEBUG_CODE_CXX

   cout << cmd << endl << flush;

#endif

   return system(cmd.c_str());
}

void
signal_handler(int arg)
{
   switch(arg) {
   case SIGINT:
   case SIGTERM:
   case SIGHUP:
      exit(0);
   break;

   case SIGCHLD:
   break;
   }
}

int
main(int argc,
     char ** argv,
     char ** envp)
{
   string file_name = "a.out";
   string in_file_name;
   string cmd;
   bool link = true;
   string_vector_type source_code;
   string_vector_type object_code;
   string_vector_type include_vec;
   string_vector_type library_vec;
   int optimize = 0;
   bool debug = true;
   //string flags = "-Wall -std=c89";
   string flags = "";
   int ret = 0;
   bool strip = false;

   signal(SIGINT, signal_handler);
   signal(SIGTERM, signal_handler);
   signal(SIGHUP, signal_handler);
   signal(SIGCHLD, signal_handler);

   for(int i = 0; i < argc; i++) {
      if(strcmp(argv[i], "-o") == 0) {
         if((i+1) < argc) {
            i++;

            file_name = argv[i];
         }
      }
      else if(strcmp(argv[i], "-c") == 0) {
         link = false;
      }
      else if(strstr(argv[i], ".c") != NULL) {
         in_file_name = string(argv[i]);
         source_code.push_back(in_file_name); 
      }
      else if(strstr(argv[i], ".o") != NULL) {
         object_code.push_back(argv[i]);
      }
      else if(strcmp(argv[i], "-I") == 0) {
         if((i+1) < argc) {
            i++;
            string temp = argv[i];
            include_vec.push_back(temp);
         }
      }
      else if(strcmp(argv[i], "-L") == 0) {
         if((i+1) < argc) {
            i++;
            string temp = argv[i];
            library_vec.push_back(temp);
         }
      }
      else if(strcmp(argv[i], "-O") == 0) {
         flags += string(argv[i]) + " ";
         optimize = 1;
      }
      else if(strcmp(argv[i], "-O2") == 0) {
         flags += string(argv[i]) + " ";
         optimize = 2;
         strip = true;
      }
      else if(strcmp(argv[i], "-O3") == 0) {
         flags += string(argv[i]) + " ";
         optimize = 3;
         strip = true;
      }
      else if(strcmp(argv[i], "-g") == 0) {
         flags += string(argv[i]) + " ";
         debug = true;
      }
      else if(strcmp(argv[i], "-strip") == 0) {
         strip = true;
      }
      else {

      }
   }
   
   cmd = string(CPP_CMD) + " " + in_file_name + " temp/temp.c";

   if((ret = System(cmd)) == 0) {

      cmd = string(CC_CMD) + " temp/temp.c temp/temp.asm";

      if((ret = System(cmd)) == 0) {

         cmd = string(ASM_CMD) + " -f elf temp/temp.asm -o temp/temp.o";

         if((ret = System(cmd)) == 0) {

            cmd = string(CP_CMD) + " temp/temp.o " + get_file_name(in_file_name) + ".o";

            if((ret = System(cmd)) == 0) {

               if(link) {
                  //cmd = string("/usr/bin/ld --eh-frame-hdr -V -dynamic-linker /libexec/ld-elf.so.1 -o ") + get_file_name(in_file_name) + string(" /usr/lib/crt1.o /usr/lib/crti.o /usr/lib/crtbegin.o -L/usr/lib -L/usr/lib ") + get_file_name(in_file_name) + string(".o -lgcc --as-needed -lgcc_s --no-as-needed -lc -lgcc --as-needed -lgcc_s --no-as-needed /usr/lib/crtend.o /usr/lib/crtn.o");

                  cmd = string(LINK_CMD) + " c_code.o " + get_file_name(in_file_name) + ".o -o " + file_name;

                  if((ret = System(cmd)) == 0) {

                     if(strip) {
                        cmd = string(STRIP_CMD) + " ./" + file_name;

                        if((ret = System(cmd)) == 0) {

                        }
                     }
                  }
               }
               else {
                  cerr << "unable to link..." << endl;
               }
            }
         }
      }
   }

   return ret;
}
