/*

(C) Copywrite 2008.  All rights reserved.
Matthew William Coan.

Standard C input and output library.

Author: Matthew William Coan
Date: Wed Nov 26 17:03:26 EST 2008

*/

#ifndef _STDIO_H
#define _STDIO_H

#include <types.h>

#define FILE_BUFFER_MAX  (1024 * 8)
#define SEEK_SET 1
#define SEEK_CUR 2
#define SEEK_END 3

extern sprintf(char * buffer, const char * fmt, ...);

typedef struct _FILE {
   int fd;
   char buffer[FILE_BUFFER_MAX];
   size_t buffer_size;
} FILE;

extern FILE * stdin;

extern FILE * stdout;

extern FILE * stderr;

extern FILE * fopen(const char * file, const char * mode);

extern int fseek(FILE * file, long address, int whence);

extern long ftell(FILE * file);

extern int fread(FILE * file, void * ptr, size_t sz, size_t n);

extern int fwrite(FILE * file, void * ptr, size_t sz, size_t n);

extern int fprintf(FILE * file, const char * fmt, ...);

extern int fgetchar(FILE * file);

extern int fflush(FILE * file);

extern int fclose(FILE * file);

extern int printf(const char * fmt, ...);

extern int scanf(const char * fmt, ...);

extern int perror(const char * msg);

#endif /* _STDIO_H */
