/*

    Copyright (C) 2009  Matthew William Coan

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

C assembly language functions.

Author: Matthew William Coan
Date: Mon May 30 04:29:02 EST 2011

*/

#ifndef _CASM_H
#define _CASM_H

typedef char char_t;
typedef unsigned char uchar_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef long long int int64_t;
typedef unsigned long long int uint64_t;
typedef float float_t;
typedef double double_t;

extern float_t float_add(float_t arg1, float_t arg2);
extern float_t float_sub(float_t arg1, float_t arg2);
extern float_t float_mul(float_t arg1, float_t arg2);
extern float_t float_div(float_t arg1, float_t arg2);
extern int32_t float_lt(float_t arg1, float_t arg2);
extern int32_t float_gt(float_t arg1, float_t arg2);
extern int32_t float_lteq(float_t arg1, float_t arg2);
extern int32_t float_gteq(float_t arg1, float_t arg2);
extern int32_t float_eq(float_t arg1, float_t arg2);
extern int32_t float_neq(float_t arg1, float_t arg2);

extern double_t double_add(double_t arg1, double_t arg2);
extern double_t double_sub(double_t arg1, double_t arg2);
extern double_t double_mul(double_t arg1, double_t arg2);
extern double_t double_div(double_t arg1, double_t arg2);
extern int32_t double_lt(double_t arg1, double_t arg2);
extern int32_t double_gt(double_t arg1, double_t arg2);
extern int32_t double_lteq(double_t arg1, double_t arg2);
extern int32_t double_gteq(double_t arg1, double_t arg2);
extern int32_t double_eq(double_t arg1, double_t arg2);
extern int32_t double_neq(double_t arg1, double_t arg2);

extern int64_t int64_add(int64_t arg1, int64_t arg2);
extern int64_t int64_sub(int64_t arg1, int64_t arg2);
extern int64_t int64_mul(int64_t arg1, int64_t arg2);
extern int64_t int64_div(int64_t arg1, int64_t arg2);
extern int64_t int64_mod(int64_t arg1, int64_t arg2);
extern int32_t int64_lt(int64_t arg1, int64_t arg2);
extern int32_t int64_gt(int64_t arg1, int64_t arg2);
extern int32_t int64_lteq(int64_t arg1, int64_t arg2);
extern int32_t int64_gteq(int64_t arg1, int64_t arg2);
extern int32_t int64_eq(int64_t arg1, int64_t arg2);
extern int32_t int64_neq(int64_t arg1, int64_t arg2);

extern uint64_t uint64_add(uint64_t arg1, uint64_t arg2);
extern uint64_t uint64_sub(uint64_t arg1, uint64_t arg2);
extern uint64_t uint64_mul(uint64_t arg1, uint64_t arg2);
extern uint64_t uint64_div(uint64_t arg1, uint64_t arg2);
extern uint64_t uint64_mod(uint64_t arg1, uint64_t arg2);
extern uint32_t uint64_lt(uint64_t arg1, uint64_t arg2);
extern uint32_t uint64_gt(uint64_t arg1, uint64_t arg2);
extern uint32_t uint64_lteq(uint64_t arg1, uint64_t arg2);
extern uint32_t uint64_gteq(uint64_t arg1, uint64_t arg2);
extern uint32_t uint64_eq(uint64_t arg1, uint64_t arg2);
extern uint32_t uint64_neq(uint64_t arg1, uint64_t arg2);

extern int32_t int32_add(int32_t arg1, int32_t arg2);
extern int32_t int32_sub(int32_t arg1, int32_t arg2);
extern int32_t int32_mul(int32_t arg1, int32_t arg2);
extern int32_t int32_div(int32_t arg1, int32_t arg2);
extern int32_t int32_mod(int32_t arg1, int32_t arg2);
extern int32_t int32_lt(int32_t arg1, int32_t arg2);
extern int32_t int32_gt(int32_t arg1, int32_t arg2);
extern int32_t int32_lteq(int32_t arg1, int32_t arg2);
extern int32_t int32_gteq(int32_t arg1, int32_t arg2);
extern int32_t int32_eq(int32_t arg1, int32_t arg2);
extern int32_t int32_neq(int32_t arg1, int32_t arg2);

extern uint32_t uint32_add(uint32_t arg1, uint32_t arg2);
extern uint32_t uint32_sub(uint32_t arg1, uint32_t arg2);
extern uint32_t uint32_mul(uint32_t arg1, uint32_t arg2);
extern uint32_t uint32_div(uint32_t arg1, uint32_t arg2);
extern uint32_t uint32_mod(uint32_t arg1, uint32_t arg2);
extern int32_t uint32_lt(uint32_t arg1, uint32_t arg2);
extern int32_t uint32_gt(uint32_t arg1, uint32_t arg2);
extern int32_t uint32_lteq(uint32_t arg1, uint32_t arg2);
extern int32_t uint32_gteq(uint32_t arg1, uint32_t arg2);
extern int32_t uint32_eq(uint32_t arg1, uint32_t arg2);
extern int32_t uint32_neq(uint32_t arg1, uint32_t arg2);

extern int16_t int16_add(int16_t arg1, int16_t arg2);
extern int16_t int16_sub(int16_t arg1, int16_t arg2);
extern int16_t int16_mul(int16_t arg1, int16_t arg2);
extern int16_t int16_div(int16_t arg1, int16_t arg2);
extern int16_t int16_mod(int16_t arg1, int16_t arg2);

extern uint16_t uint16_add(uint16_t arg1, uint16_t arg2);
extern uint16_t uint16_sub(uint16_t arg1, uint16_t arg2);
extern uint16_t uint16_mul(uint16_t arg1, uint16_t arg2);
extern uint16_t uint16_div(uint16_t arg1, uint16_t arg2);
extern uint16_t uint16_mod(uint16_t arg1, uint16_t arg2);

extern char_t char_add(char_t arg1, char_t arg2);
extern char_t char_sub(char_t arg1, char_t arg2);
extern char_t char_mul(char_t arg1, char_t arg2);
extern char_t char_div(char_t arg1, char_t arg2);
extern char_t char_mod(char_t arg1, char_t arg2);

extern uchar_t uchar_add(uchar_t arg1, uchar_t arg2);
extern uchar_t uchar_sub(uchar_t arg1, uchar_t arg2);
extern uchar_t uchar_mul(uchar_t arg1, uchar_t arg2);
extern uchar_t uchar_div(uchar_t arg1, uchar_t arg2);
extern uchar_t uchar_mod(uchar_t arg1, uchar_t arg2);

#endif /* _CASM_H */
