/*

    Copyright (C) 2009  Matthew William Coan

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.


C macro pre-parser.

Author: Matthew William Coan
Date: Wed Nov 26 19:04:12 EST 2008

*/

#include <iostream>
#include <fstream>
#include <string>
#include <map>
#include <stack>

#include <cstdlib>
#include <cstring>
#include <cctype>

using namespace std;

const char * include_dir[] = {
   "/home/mcoan/c++/",
   "./",
   NULL
};

class cpp {
public:

typedef map< string, string > string_map_type;

string_map_type define_map;

string
file_name(const string & macro)
{
   string the_file_name;

   const char * p = macro.c_str();

   while(*p) {
      if(*p == '<') {
         p++;

         while(*p) {
            if(*p == '>') {
               break;
            }

            the_file_name += *p;

            p++;
         }

         break;
      }

      p++;
   }

   return the_file_name;
}

string
get_file_name(const string & inc)
{
   string ret;

   size_t i = 0;

   while(i < inc.size()) {
      if(isspace(inc[i])) {
         i++;
         continue;
      }

      if(inc[i] == '<' || inc[i] == '\"') {
         i++;

         while(inc[i] != '>' && inc[i] != '\"') {
            ret += inc[i];

            i++;
         }

         break;
      }

      i++;
   }

   return ret;
}

string_map_type include_map;

void
include_file(const string & inc_file_name, 
             ofstream & output)
{
   bool found = false;
   string fn = get_file_name(inc_file_name);
   int ch;

   for(size_t i = 0; include_dir[i] != NULL; i++) {
      string the_file_name = string(include_dir[i]) + fn;

      if(include_map.find(fn) == include_map.end()) {
         include_map[fn] = "TRUE";
      }
      else {
         return;
      }

cout << "fn: \"" << fn << "\"" << endl << flush;
cout << "include: \"" << the_file_name << "\"" << endl << flush;

      ifstream fin(the_file_name.c_str(), ios::in);

      if(!fin) {
         continue;
      }

      found = true;

      while(true) {
         ch = fin.get();

         if(!fin) {
            break;
         }

         output << static_cast< char >(ch); 
      }

      output.flush();

      fin.close();
   }

   if(!found) {
      cerr << "include file " 
           << fn 
           << " not found..." << endl;

      exit(1);
   }
}

void
macro_define(const string & macro)
{
   const char * p = macro.c_str();

   p += 8;

   string def;
   string val;
   bool get_val = false;
   bool in = false;

   while(*p) {
      if((*p) == '\n') {
         break;
      }
      else if((*p) == ' ') {
         get_val = true;
      }
      else {
         if(get_val) {
            val += (*p);
         }
         else {
            def += (*p);
         }
      }

      p++;
   }

   define_map[def] = val;
}

bool
ifndef(const string & macro)
{
   const char * p = macro.c_str();

   p += 8;

   string def;

   while(*p) {
      def += (*p);

      p++;
   }

   bool ret = false;

   if(define_map.find(def) == define_map.end()) {
      ret = true;
   }

   return ret;
}

bool
ifdef(const string & macro) 
{
   const char * p = macro.c_str();

   if(macro.size() < 7)
      return false; 

   p += 7;

   string def;

   while(*p) {
      def += (*p);

      p++;
   }

   bool ret = false;

   if(define_map.find(def) != define_map.end()) {
      ret = true;
   }

   return ret;
}

bool skip;

bool
endif(const string & macro)
{
   bool ret = true;

   return ret;
}

typedef stack< bool > skip_stack_type;

skip_stack_type skip_stack;

void
process_macro(const string & macro,
              ofstream & output)
{
   //skip = false;

   if(strstr(macro.c_str(), "#define") == macro.c_str()) {
      macro_define(macro);
   }
   else if(strstr(macro.c_str(), "#include") == macro.c_str()) {
      include_file(macro, output);
   }
   else if(strstr(macro.c_str(), "#ifdef") == macro.c_str()) {
      skip_stack.push(skip);
      if(ifdef(macro)) {
         skip = false;
      }
      else {
         skip = true;
      }
   }
   else if(strstr(macro.c_str(), "#ifndef") == macro.c_str()) {
      skip_stack.push(skip);

      if(ifndef(macro)) {
         skip = false;
      }
      else {
         skip = true;
      }
   }
   else if(strstr(macro.c_str(), "#endif") == macro.c_str()) {
      endif(macro);

      skip = skip_stack.top();

      skip_stack.pop();
   }
   else {
      cerr << "macro: \"" << macro << "\"" << endl;
      cerr << "error: bad macro..." <<  endl;

      exit(1);
   }
}

void
swap(string & str1, 
     string & str2)
{
   string temp = str1;

   str1 = str2;

   str2 = temp;
}

int
main_loop(int argc,
          char ** argv,
          char ** envp)
{
   string macro;
   char ch;

   if(argc < 3) {
      cerr << "error: usage: " << argv[0] 
           << " <input> <output>" << endl;

      exit(1);
   }

   const char * infile = argv[1];
   const char * outfile = argv[2];

   if(infile == NULL) {
      cerr << "no input file found..." << endl;
      exit(1);
   }

   if(outfile == NULL) {
      cerr << "no output file found..." << endl;
      exit(1);
   }

   string file_name0 = string(infile);

   string file_name1 = string(outfile);

   string temp_file = string("./temp_file_name.c");

   while(true) {
   
      ifstream input(file_name0.c_str());

      if(!input) {
         cerr << "error: unable to open input file..." << endl;

         exit(1);
      }

      ofstream output(file_name1.c_str());

      if(!output) {
         cerr << "error: unable to open output file..." << endl;

         exit(1);
      }

      skip = false;

      bool comment = false;

      bool did_something = false;

      while(input) {
         ch = input.get();

         if(!input) {
            break;
         }

         if(ch == '#' && !comment) {
            macro = "#";

            while((ch = input.get()) != '\n') {
               macro += ch;
            }

            process_macro(macro, output);

            did_something = true;
         } 
         else if(ch == '/' && input.peek() == '*') {
            ch = input.get();

            comment = true;

            did_something = true;
         }
         else if(ch == '*' && input.peek() == '/') {
            ch = input.get();

            comment = false;

            did_something = true;
         }
         else if(comment) {
            did_something = true;
         }
         else {
            if(!skip) {
               output << ch << flush;
            }
         }
      }

      output.flush();
      output.close();
      input.close();

      if(!did_something) {
         break;
      }

      if(file_name0 == temp_file) {
         swap(file_name0, file_name1);
      }
      else if(file_name1 == temp_file) {
         swap(file_name0, file_name1);
      }
      else {
         file_name0 = file_name1;
         file_name1 = temp_file;
      }
   }

   if(file_name1 == temp_file) {
      ofstream out(argv[2], ios::trunc | ios::ate | ios::out);
      ifstream in(temp_file.c_str(), ios::in);
      if(in && out) {
         char ch;
         ch = in.get();
         while(in) {
            out << ch;
            ch = in.get();
         }
         out << flush;
         in.close();
         out.close();
      }
   }

   return 0;
}

};


int
main(int argc,
     char ** argv,
     char ** envp)
{
   cpp c_pre_processor;

   register int rc = c_pre_processor.main_loop(argc, argv, envp);
   
   return rc;
}

