#include <iostream>
#include <fstream>
#include <string>

using namespace std;

class code_gen {
public:
   code_gen() 
   {
   }

   ~code_gen()
   {
   }

   bool bad_code(const string & t1, const string & t2, const string & op) 
   {
      bool ret = false;

      if(t1 == "double" || t1 == "float" || t2 == "double" || t2 == "float") {
         if(op == "%" || op == "<<" || op == ">>" || op == "&" || op == "|" || op == "^" || op == "~") {
            ret = true;
         }
      }

      return ret;
   }

   void run() 
   {
      ofstream out("c_code.c", ios::ate | ios::trunc | ios::out);
      ofstream out_asm("c_code2.asm", ios::ate | ios::trunc | ios::out);
      ofstream out_h("c_code.h", ios::ate | ios::trunc | ios::out);

      if(out && out_h) {
         const char * native_type2[] = { 
              "unsigned char", "char", "unsigned short", "short",
              "unsigned int", "int", "unsigned long long *", "long long *", "float", 
              "double *", NULL };

         const char * native_type[] = { 
              "uchar", "char", "ushort", "short",
              "uint", "int", "ulong", "long", "float", 
              "double", NULL };

         const char * operation_array[] = { 
              "add", "sub", "mul", "div", "mod", "ls", "rs", 
              "lt", "gt", "eq", "lteq", "gteq", "neq", "neg", 
              "and", "or", "not", "band", "bor", "xor", "bnot", NULL };

         const char * operator_array[] = {
              "+", "-", "*", "/", "%", "<<", ">>", "<", ">", "==",
              "<=", ">=", "!=", "-", "&&", "||", "!", "&", "|", "^", "~", NULL };

         out_h << "#ifndef _C_CODE_H" << endl << flush;
         out_h << "#define _C_CODE_H" << endl << flush;
         out_h << endl << flush;

         for(size_t t = 0; native_type[t] != NULL; t++) {
            out_h << "typedef " << native_type2[t] << " " << native_type[t] << "_t;" << endl << flush;
         }
         out_h << endl << flush;

         for(size_t t = 0, t2 = 0; native_type[t] != NULL; t++, t2++) {
            //for(size_t t2 = 0; native_type[t2] != NULL; t2++) {
               for(size_t i = 0; operation_array[i] != NULL && operator_array[i] != NULL; i++) {
                  if(bad_code(native_type[t], native_type[t2], operator_array[i])) 
                     continue;

                  if(strcmp(native_type[t], "double") == 0
                     || strcmp(native_type[t], "long") == 0
                     || strcmp(native_type[t], "ulong") == 0) {
                     out_h << "extern void " << native_type[t] << "__" << native_type[t2] << "__" << operation_array[i]
                           << " ( " << native_type[t] << "_t arg1 , " << native_type[t2] << "_t arg2 , " 
                           << native_type[t] << "_t arg3 ) "
                           << ";" << endl << flush;
                  }
                  else {
                     out_h << "extern " << native_type[t] 
                           << "_t " << native_type[t] << "__" << native_type[t2] << "__" << operation_array[i]
                           << " ( " << native_type[t] << "_t arg1 , " << native_type[t2] << "_t arg2 ) "
                           << ";" << endl << flush;
                  }

                  out_asm << "extern " << native_type[t] << "__" << native_type[t2] << "__" << operation_array[i] << endl << flush;
               }
            //}
         }

         out_h << "#endif /* _C_CODE_H */" << endl << flush;

         out << "#include \"c_code.h\"" << endl << endl << flush;

         for(size_t t = 0, t2 = 0; native_type[t] != NULL; t++, t2++) {
            //for(size_t t2 = 0; native_type[t2] != NULL; t2++) {
               for(size_t i = 0; operation_array[i] != NULL && operator_array[i] != NULL; i++) {
                  if(bad_code(native_type[t], native_type[t2], operator_array[i])) 
                     continue;

                  if(strcmp(native_type[t], "double") == 0
                     || strcmp(native_type[t], "long") == 0
                     || strcmp(native_type[t], "ulong") == 0) {
                     out << "void " << native_type[t] << "__" << native_type[t2] << "__" << operation_array[i]
                         << " ( " << native_type[t] << "_t arg1 , " << native_type[t2] << "_t arg2 , " 
                         << native_type[t] << "_t arg3 ) "
                         << endl << "{" << endl << endl << flush;
                  }
                  else {
                     out << native_type[t] << "_t " << native_type[t] << "__" << native_type[t2] << "__" << operation_array[i]
                         << " ( " << native_type[t] << "_t arg1 , " << native_type[t2] << "_t arg2 ) "
                         << endl << "{" << endl << endl << flush;
                  }
                
                  if(operator_array[i] == string("~") || operator_array[i] == string("!") || operation_array[i] == string("neg")) {
                     if(strcmp(native_type[t], "double") == 0
                        || strcmp(native_type[t], "long") == 0
                        || strcmp(native_type[t], "ulong") == 0) {
                        out << "   *arg1 = " << operator_array[i] << " *arg2;" << endl << endl << flush;
                     }
                     else {
                        out << "   arg1 = " << operator_array[i] << " arg2;" << endl << endl << flush;
                        out << "   return arg1;" << endl << endl << flush;
                     }
                  }
                  else if(strcmp(native_type[t], "double") == 0
                          || strcmp(native_type[t], "long") == 0
                          || strcmp(native_type[t], "ulong") == 0) {
                      out << "   *arg3 = *arg1 " << operator_array[i] << " *arg2;" << endl << endl << flush;
                  }
                  else {
                      out << "   arg1 = arg1 " << operator_array[i] << " arg2;" << endl << endl << flush;
                      out << "   return arg1;" << endl << endl << flush;
                  }

                  out << "}" << endl << endl << endl << flush;
               }
            //}
         }

         out_asm.close();
         out_h.close();
         out.close();
      }
   }
};

int
main(int argc, char ** argv, char ** envp)
{
   code_gen cg;
   cg.run();
   return 0;
}
