;
; i386 ASSEMBOLOY LANGUAGE MACRO DEFINITIONS...
;
;
; Author: Matthew William Coan
; Date: Sun Nov 15 02 005 059 EST 2009
;

; --

;%include "c_code.asm"

%macro address_get 0
        push    ebp
        mov     ebp,esp
        mov     eax, [ebp+20-4]
        imul    eax, [ebp+12-4]
        add     eax, [ebp+8-4]
        mov     edx, [ebp+16-4]
        mov     [edx],eax
	mov	esp,ebp
	pop	ebp
%endmacro

%macro _ulong_div 0
        push    ebp
        mov     ebp,esp
        sub     esp,24
        mov     eax, [ebp+8-4]
        mov     [ebp-8],eax
        mov     eax, [ebp+12-4]
        mov     [ebp-4],eax
        mov     eax, [ebp+16-4]
        mov     [ebp-16],eax
        mov     eax, [ebp+20-4]
        mov     [ebp-12],eax
        push    dword [ebp-12]
        push    dword [ebp-16]
        push    dword [ebp-4]
        push    dword [ebp-8]
        call    __udivdi3
        add     esp,16
        mov     ecx, [ebp+24-4]
        mov     [ecx],eax
        mov     [ecx+4],edx
        mov     esp,ebp
        pop     ebp
%endmacro


%macro _ulong_mul 0
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+8-4]
        mov     [ebp-8],eax
        mov     eax, [ebp+12-4]
        mov     [ebp-4],eax
        mov     eax, [ebp+16-4]
        mov     [ebp-16],eax
        mov     eax, [ebp+20-4]
        mov     [ebp-12],eax
        mov     eax, [ebp-4]
        mov     ecx,eax
        imul    ecx, [ebp-16]
        mov     eax, [ebp-12]
        imul    eax, [ebp-8]
        add     ecx,eax
        mov     eax, [ebp-16]
        mul     dword [ebp-8]
        add     ecx,edx
        mov     edx,ecx
        mov     ecx, [ebp+24-4]
        mov     [ecx],eax
        mov     [ecx+4],edx
        mov     esp,ebp
        pop     ebp
%endmacro


%macro _long_mul 0
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+8-4]
        mov     [ebp-8],eax
        mov     eax, [ebp+12-4]
        mov     [ebp-4],eax
        mov     eax, [ebp+16-4]
        mov     [ebp-16],eax
        mov     eax, [ebp+20-4]
        mov     [ebp-12],eax
        mov     eax, [ebp-4]
        mov     ecx,eax
        imul    ecx, [ebp-16]
        mov     eax, [ebp-12]
        imul    eax, [ebp-8]
        add     ecx,eax
        mov     eax, [ebp-16]
        mul     dword [ebp-8]
        add     ecx,edx
        mov     edx,ecx
        mov     ecx, [ebp+24-4]
        mov     [ecx],eax
        mov     [ecx+4],edx
        mov     esp,ebp
        pop     ebp
%endmacro


%macro _long_div 0
        push    ebp
        mov     ebp,esp
        sub     esp,24
        mov     eax, [ebp+8-4]
        mov     [ebp-8],eax
        mov     eax, [ebp+12-4]
        mov     [ebp-4],eax
        mov     eax, [ebp+16-4]
        mov     [ebp-16],eax
        mov     eax, [ebp+20-4]
        mov     [ebp-12],eax
        push    dword [ebp-12]
        push    dword [ebp-16]
        push    dword [ebp-4]
        push    dword [ebp-8]
        call    __divdi3
        add     esp,16
        mov     ecx, [ebp+24-4]
        mov     [ecx],eax
        mov     [ecx+4],edx
        mov     esp,ebp
        pop     ebp
%endmacro



%macro mov_struct 3
	push	%3
	lea	edx,%2
	push	edx
	lea	edx,%1
	push	edx
	call	memcpy
	add	esp,12
%endmacro

%macro mov_struct2 3
	push	%3
	push	%2
	lea	edx,%1
	push	edx
	call	memcpy
	add	esp,12
%endmacro

%macro mov_struct3 3
	push	%3
	push	%2
	push	%1
	call	memcpy
	add	esp,12
%endmacro

%macro array_get 0 
        push    ebp
        mov     ebp,esp
        push    edi
        push    esi
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-12],eax
        mov     eax, [ebp+24-4]
        mov     edx,eax
        add     edx, [ebp-12]
        mov     eax, [ebp+16-4]
        mov     ecx, [ebp+28-4]
        mov     edi,eax
        mov     esi,edx
        cld
        rep movsb
        mov     eax,0
        add     esp,16
        pop     esi
        pop     edi
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro array_put 0 
        push    ebp
        mov     ebp,esp
        push    edi
        push    esi
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-12],eax
        mov     eax, [ebp+24-4]
        add     eax, [ebp-12]
        mov     edx, [ebp+16-4]
        mov     ecx, [ebp+28-4]
        mov     edi,eax
        mov     esi,edx
        cld
        rep movsb
        mov     eax,0
        add     esp,16
        pop     esi
        pop     edi
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro add_array_put_int 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        add     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro sub_array_put_int 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        sub     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro mul_array_put_int 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        imul    edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro div_array_put_int 0 
        push    ebp
        mov     ebp,esp
        sub     esp,20
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        mov     [ebp-20],eax
        mov     eax,edx
        cdq
        idiv    dword [ebp-20]
        mov     [ebp-20],eax
        mov     edx, [ebp-20]
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro add_array_put_float 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        fld     dword [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        fld     dword [eax]
        faddp   st1,st0
        mov     eax, [ebp-4]
        fstp    dword [eax]
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro sub_array_put_float 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        fld     dword [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        fld     dword [eax]
        fsubrp  st1,st0
        mov     eax, [ebp-4]
        fstp    dword [eax]
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro mul_array_put_float 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        fld     dword [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        fld     dword [eax]
        fmulp   st1,st0
        mov     eax, [ebp-4]
        fstp    dword [eax]
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro div_array_put_float 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        fld     dword [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        fld     dword [eax]
        fdivrp  st1,st0
        mov     eax, [ebp-4]
        fstp    dword [eax]
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro add_array_put_char 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     al, [eax]
        mov     dl,al
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     al, [eax]
        lea     eax, [edx+eax]
        mov     dl,al
        mov     eax, [ebp-4]
        mov     [eax],dl
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro sub_array_put_char 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     al, [eax]
        mov     dl,al
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     al, [eax]
        mov     cl,dl
        sub     cl,al
        mov     al,cl
        mov     dl,al
        mov     eax, [ebp-4]
        mov     [eax],dl
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro mul_array_put_char 0 
        push    ebp
        mov     ebp,esp
        sub     esp,20
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     dl, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     al, [eax]
        mov     [ebp-17],al
        mov     al, [ebp-17]
        mul     dl
        mov     dl,al
        mov     eax, [ebp-4]
        mov     [eax],dl
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro
        
        

%macro div_array_put_char 0 
        push    ebp
        mov     ebp,esp
        sub     esp,20
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     al, [eax]
        movsx   edx,al
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     al, [eax]
        movsx   eax,al
        mov     [ebp-20],eax
        mov     eax,edx
        cdq
        idiv    dword [ebp-20]
        mov     [ebp-20],eax
        mov     eax, [ebp-20]
        mov     dl,al
        mov     eax, [ebp-4]
        mov     [eax],dl
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro
        
        

%macro add_array_put_short 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     ax, [eax]
        mov     edx,eax
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     al, [eax]
        cbw
        lea     eax, [edx+eax]
        mov     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],dx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro
        
        

%macro sub_array_put_short 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     ax, [eax]
        mov     edx,eax
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     al, [eax]
        cbw
        mov     ecx,edx
        sub     cx,ax
        mov     eax,ecx
        mov     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],dx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro
        
        

%macro mul_array_put_short 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     dx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     al, [eax]
        cbw
        imul    dx,ax
        mov     eax, [ebp-4]
        mov     [eax],dx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro
        
        

%macro div_array_put_short 0 
        push    ebp
        mov     ebp,esp
        sub     esp,20
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     ax, [eax]
        movsx   edx,ax
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     al, [eax]
        movsx   eax,al
        mov     [ebp-20],eax
        mov     eax,edx
        cdq
        idiv    dword [ebp-20]
        mov     [ebp-20],eax
        mov     eax, [ebp-20]
        mov     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],dx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro
        
        

%macro add_array_put_long 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        add     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro sub_array_put_long 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        sub     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro mul_array_put_long 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        imul    edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro div_array_put_long 0 
        push    ebp
        mov     ebp,esp
        sub     esp,20
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        mov     [ebp-20],eax
        mov     eax,edx
        cdq
        idiv    dword [ebp-20]
        mov     [ebp-20],eax
        mov     edx, [ebp-20]
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro add_array_put_double 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        fld     dword [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        fld     dword [eax]
        faddp   st1,st0
        mov     eax, [ebp-4]
        fstp    dword [eax]
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro sub_array_put_double 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        fld     dword [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        fld     dword [eax]
        fsubrp  st1,st0
        mov     eax, [ebp-4]
        fstp    dword [eax]
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro mul_array_put_double 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        fld     dword [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        fld     dword [eax]
        fmulp   st1,st0
        mov     eax, [ebp-4]
        fstp    dword [eax]
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro div_array_put_double 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        fld     dword [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        fld     dword [eax]
        fdivrp  st1,st0
        mov     eax, [ebp-4]
        fstp    dword [eax]
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro add_array_put_uint 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        add     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro sub_array_put_uint 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        sub     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro mul_array_put_uint 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        imul    edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro div_array_put_uint 0 
        push    ebp
        mov     ebp,esp
        sub     esp,20
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        mov     [ebp-20],eax
        mov     eax,edx
        mov     edx,0
        div     dword [ebp-20]
        mov     [ebp-20],eax
        mov     edx, [ebp-20]
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro add_array_put_uchar 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     dl, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     al, [eax]
        add     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],dl
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro sub_array_put_uchar 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     dl, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     al, [eax]
        sub     dl,al
        mov     eax, [ebp-4]
        mov     [eax],dl
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro mul_array_put_uchar 0 
        push    ebp
        mov     ebp,esp
        sub     esp,20
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     dl, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     al, [eax]
        mov     [ebp-17],al
        mov     al, [ebp-17]
        mul     dl
        mov     dl,al
        mov     eax, [ebp-4]
        mov     [eax],dl
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro div_array_put_uchar 0 
        push    ebp
        mov     ebp,esp
        sub     esp,20
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     cl, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     dl, [eax]
        movzx   cx,cl
        mov     [ebp-18],cx
        mov     ax, [ebp-18]
        div     dl
        mov     dl,al
        mov     eax, [ebp-4]
        mov     [eax],dl
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro add_array_put_ushort 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     dx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     ax, [eax]
        add     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],dx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro sub_array_put_ushort 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     dx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     ax, [eax]
        sub     dx,ax
        mov     eax, [ebp-4]
        mov     [eax],dx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro
        

        

%macro mul_array_put_ushort 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     dx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     ax, [eax]
        imul    dx,ax
        mov     eax, [ebp-4]
        mov     [eax],dx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro div_array_put_ushort 0 
        push    ebp
        mov     ebp,esp
        sub     esp,20
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     cx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     ax, [eax]
        mov     [ebp-18],ax
        mov     edx,0
        mov     eax,ecx
        div     word [ebp-18]
        mov     [ebp-18],ax
        mov     dx, [ebp-18]
        mov     eax, [ebp-4]
        mov     [eax],dx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro add_array_put_ulong 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        add     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro sub_array_put_ulong 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        sub     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro mul_array_put_ulong 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        imul    edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro div_array_put_ulong 0 
        push    ebp
        mov     ebp,esp
        sub     esp,20
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        mov     [ebp-20],eax
        mov     eax,edx
        mov     edx,0
        div     dword [ebp-20]
        mov     [ebp-20],eax
        mov     edx, [ebp-20]
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro and_array_put_int 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        and     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro or_array_put_int 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        or      edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro xor_array_put_int 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        xor     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro rsh_array_put_int 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     ecx, [eax]
        sar     edx,cl
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro lsh_array_put_int 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     ecx, [eax]
        sal     edx,cl
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro and_array_put_uint 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        and     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro or_array_put_uint 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        or      edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro xor_array_put_uint 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        xor     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro rsh_array_put_uint 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        mov     ecx,eax
        shr     edx,cl
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro lsh_array_put_uint 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        mov     ecx,eax
        sal     edx,cl
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro and_array_put_char 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     dl, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     al, [eax]
        and     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],dl
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro or_array_put_char 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     dl, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     al, [eax]
        or      edx,eax
        mov     eax, [ebp-4]
        mov     [eax],dl
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro xor_array_put_char 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     dl, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     al, [eax]
        xor     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],dl
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro rsh_array_put_char 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     al, [eax]
        movsx   edx,al
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     al, [eax]
        movsx   ecx,al
        mov     eax,edx
        sar     eax,cl
        mov     dl,al
        mov     eax, [ebp-4]
        mov     [eax],dl
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro lsh_array_put_char 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     al, [eax]
        movsx   edx,al
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     al, [eax]
        movsx   ecx,al
        mov     eax,edx
        sal     eax,cl
        mov     dl,al
        mov     eax, [ebp-4]
        mov     [eax],dl
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro and_array_put_uchar 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     dl, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     al, [eax]
        and     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],dl
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro or_array_put_uchar 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     dl, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     al, [eax]
        or      edx,eax
        mov     eax, [ebp-4]
        mov     [eax],dl
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro xor_array_put_uchar 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     dl, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     al, [eax]
        xor     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],dl
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro rsh_array_put_uchar 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     al, [eax]
        movzx   edx,al
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     al, [eax]
        movzx   ecx,al
        mov     eax,edx
        sar     eax,cl
        mov     dl,al
        mov     eax, [ebp-4]
        mov     [eax],dl
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro lsh_array_put_uchar 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     al, [eax]
        movzx   edx,al
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     al, [eax]
        movzx   ecx,al
        mov     eax,edx
        sal     eax,cl
        mov     dl,al
        mov     eax, [ebp-4]
        mov     [eax],dl
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro and_array_put_short 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     dx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     ax, [eax]
        and     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],dx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro or_array_put_short 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     dx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     ax, [eax]
        or      edx,eax
        mov     eax, [ebp-4]
        mov     [eax],dx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro xor_array_put_short 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     dx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     ax, [eax]
        xor     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],dx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro rsh_array_put_short 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     ax, [eax]
        movsx   edx,ax
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     ax, [eax]
        movsx   ecx,ax
        mov     eax,edx
        sar     eax,cl
        mov     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],dx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro lsh_array_put_short 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     ax, [eax]
        movsx   edx,ax
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     ax, [eax]
        movsx   ecx,ax
        mov     eax,edx
        sal     eax,cl
        mov     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],dx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro and_array_put_ushort 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     dx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     ax, [eax]
        and     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],dx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro or_array_put_ushort 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     dx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     ax, [eax]
        or      edx,eax
        mov     eax, [ebp-4]
        mov     [eax],dx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro xor_array_put_ushort 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     dx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     ax, [eax]
        xor     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],dx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro rsh_array_put_ushort 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     ax, [eax]
        movzx   edx,ax
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     ax, [eax]
        movzx   ecx,ax
        mov     eax,edx
        sar     eax,cl
        mov     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],dx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro lsh_array_put_ushort 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     ax, [eax]
        movzx   edx,ax
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     ax, [eax]
        movzx   ecx,ax
        mov     eax,edx
        sal     eax,cl
        mov     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],dx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro and_array_put_long 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        and     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro or_array_put_long 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        or      edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro xor_array_put_long 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        xor     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro rsh_array_put_long 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     ecx, [eax]
        sar     edx,cl
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro lsh_array_put_long 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     ecx, [eax]
        sal     edx,cl
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro and_array_put_ulong 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        and     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro or_array_put_ulong 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        or      edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro xor_array_put_ulong 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        xor     edx,eax
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro rsh_array_put_ulong 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        mov     ecx,eax
        shr     edx,cl
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
        mov     esp,ebp
        pop     ebp 
%endmacro

        
        

%macro lsh_array_put_ulong 0 
        push    ebp
        mov     ebp,esp
        sub     esp,16
        mov     eax, [ebp+12-4]
        imul    eax, [ebp+20-4]
        add     eax, [ebp+8-4]
        mov     [ebp-4],eax
        mov     eax, [ebp-4]
        mov     edx, [eax]
        mov     eax, [ebp+24-4]
        add     eax, [ebp+16-4]
        mov     eax, [eax]
        mov     ecx,eax
        sal     edx,cl
        mov     eax, [ebp-4]
        mov     [eax],edx
        mov     eax,0
	mov	esp,ebp
	pop	ebp
%endmacro
        
; ---

; basic push pop and mov macros for different memory sizes

%macro array_get_m 0
   call array_get
%endmacro 

%macro array_put_m 0
   call array_put
%endmacro 

%macro push_byte 1
   push %1
%endmacro 

%macro push_word 1
    mov eax,esp
    sub esp,2
    mov [eax],%1
;   push %1
%endmacro 

%macro push_dword 1
;   push dword [ebp+%1]
   push dword %1
%endmacro 

%macro push_qword 1
   mov edx,dword [%1+4]
   mov ebx,dword [%1]
   push dword edx
   push dword ebx
%endmacro 

%macro pop_byte 1
%endmacro 

%macro pop_word 1
%endmacro 

%macro pop_dword 1
%endmacro 

%macro pop_qword 1
   pop dword [ebp+%1]
   pop dword [ebp+%1+4]
%endmacro 

%macro mov_qword 2
   mov edx,dword [%2+4]
   mov ebx,dword [%2]
   mov [%1+4],dword edx
   mov [%1],dword ebx
%endmacro 

%macro mov_dword 2
   mov %1,%2
%endmacro

%macro mov_word 2
   mov %1,%2
%endmacro

%macro mov_byte 2
   mov %1,%2
%endmacro

%macro r_val 2 
   mov eax,%2
   mov edx,dword [eax]
   mov %1,dword edx
%endmacro

%macro l_val 2 
   mov edx,%2
   mov eax,%1
   mov dword [eax],dword edx
%endmacro


; ---

%include "c_code_macro.asm"

