#ifndef _MACHINE_CODE_H
#define _MACHINE_CODE_H

/*

machine_code.h - standard C 89 codes for all the machine operations used by the C compiler.

multi-platform C compiler.

Author: Matthew William Coan
Date: Wed Jul  6 19:28:28 EST 2011

*/

typedef unsigned long long int uint64_t;
typedef long long int int64_t;
typedef unsigned int uint32_t;
typedef int int32_t;
typedef unsigned short uint16_t;
typedef short int16_t;
typedef unsigned char uint8_t;
typedef char int8_t;
typedef float float32_t;
typedef double double64_t;
typedef long double double128_t;
typedef unsigned long long long int uint128_t;
typedef long long long int int128_t;

extern void int64_add(int64_t * a, int64_t * b);
extern void int64_sub(int64_t * a, int64_t * b);
extern void int64_mul(int64_t * a, int64_t * b);
extern void int64_div(int64_t * a, int64_t * b);
extern void int64_mod(int64_t * a, int64_t * b);
extern void int64_lt(int64_t * a, int64_t * b);
extern void int64_gt(int64_t * a, int64_t * b);
extern void int64_eq(int64_t * a, int64_t * b);
extern void int64_neq(int64_t * a, int64_t * b);
extern void int64_neq(int64_t * a, int64_t * b);
extern void int64_lteq(int64_t * a, int64_t * b);
extern void int64_gteq(int64_t * a, int64_t * b);
extern void int64_and(int64_t * a, int64_t * b);
extern void int64_or(int64_t * a, int64_t * b);
extern void int64_not(int64_t * a);
extern void int64_lsh(int64_t * a, int64_t * b);
extern void int64_rsh(int64_t * a, int64_t * b);
extern void int64_b_and(int64_t * a, int64_t * b);
extern void int64_b_or(int64_t * a, int64_t * b);
extern void int64_b_not(int64_t * a);
extern void int64_b_xor(int64_t * a, int64_t * b);
extern void int64_lval(int64_t * a, int64_t * b);
extern void int64_rval(int64_t * a, int64_t * b);

extern void uint64_add(uint64_t * a, uint64_t * b);
extern void uint64_sub(uint64_t * a, uint64_t * b);
extern void uint64_mul(uint64_t * a, uint64_t * b);
extern void uint64_div(uint64_t * a, uint64_t * b);
extern void uint64_mod(uint64_t * a, uint64_t * b);
extern void uint64_lt(uint64_t * a, uint64_t * b);
extern void uint64_gt(uint64_t * a, uint64_t * b);
extern void uint64_eq(uint64_t * a, uint64_t * b);
extern void uint64_neq(uint64_t * a, uint64_t * b);
extern void uint64_neq(uint64_t * a, uint64_t * b);
extern void uint64_lteq(uint64_t * a, uint64_t * b);
extern void uint64_gteq(uint64_t * a, uint64_t * b);
extern void uint64_and(uint64_t * a, uint64_t * b);
extern void uint64_or(uint64_t * a, uint64_t * b);
extern void uint64_not(uint64_t * a);
extern void uint64_lsh(uint64_t * a, uint64_t * b);
extern void uint64_rsh(uint64_t * a, uint64_t * b);
extern void uint64_b_and(uint64_t * a, uint64_t * b);
extern void uint64_b_or(uint64_t * a, uint64_t * b);
extern void uint64_b_not(uint64_t * a);
extern void uint64_b_xor(uint64_t * a, uint64_t * b);
extern void uint64_lval(uint64_t * a, uint64_t * b);  
extern void uint64_rval(uint64_t * a, uint64_t * b);  

extern void uint32_add(uint32_t * a, uint32_t * b);
extern void uint32_sub(uint32_t * a, uint32_t * b);
extern void uint32_mul(uint32_t * a, uint32_t * b);
extern void uint32_div(uint32_t * a, uint32_t * b);
extern void uint32_mod(uint32_t * a, uint32_t * b);
extern void uint32_lt(uint32_t * a, uint32_t * b);
extern void uint32_gt(uint32_t * a, uint32_t * b);
extern void uint32_eq(uint32_t * a, uint32_t * b);
extern void uint32_neq(uint32_t * a, uint32_t * b);
extern void uint32_neq(uint32_t * a, uint32_t * b);
extern void uint32_lteq(uint32_t * a, uint32_t * b);
extern void uint32_gteq(uint32_t * a, uint32_t * b);
extern void uint32_and(uint32_t * a, uint32_t * b);
extern void uint32_or(uint32_t * a, uint32_t * b);
extern void uint32_not(uint32_t * a);
extern void uint32_lsh(uint32_t * a, uint32_t * b);
extern void uint32_rsh(uint32_t * a, uint32_t * b);
extern void uint32_b_and(uint32_t * a, uint32_t * b);
extern void uint32_b_or(uint32_t * a, uint32_t * b);
extern void uint32_b_not(uint32_t * a);
extern void uint32_b_xor(uint32_t * a, uint32_t * b);
extern void uint32_lval(uint32_t * a, uint32_t * b);
extern void uint32_rval(uint32_t * a, uint32_t * b);

extern void int32_add(int32_t * a, int32_t * b); 
extern void int32_sub(int32_t * a, int32_t * b);
extern void int32_mul(int32_t * a, int32_t * b);
extern void int32_div(int32_t * a, int32_t * b);
extern void int32_mod(int32_t * a, int32_t * b);
extern void int32_lt(int32_t * a, int32_t * b);
extern void int32_gt(int32_t * a, int32_t * b);
extern void int32_eq(int32_t * a, int32_t * b);
extern void int32_neq(int32_t * a, int32_t * b);
extern void int32_neq(int32_t * a, int32_t * b);
extern void int32_lteq(int32_t * a, int32_t * b);
extern void int32_gteq(int32_t * a, int32_t * b);
extern void int32_and(int32_t * a, int32_t * b);
extern void int32_or(int32_t * a, int32_t * b);
extern void int32_not(int32_t * a);
extern void int32_lsh(int32_t * a, int32_t * b);
extern void int32_rsh(int32_t * a, int32_t * b);
extern void int32_b_and(int32_t * a, int32_t * b);
extern void int32_b_or(int32_t * a, int32_t * b);
extern void int32_b_not(int32_t * a);
extern void int32_b_xor(int32_t * a, int32_t * b);
extern void int32_lval(int32_t * a, int32_t * b);
extern void int32_rval(int32_t * a, int32_t * b);

extern void uint16_add(uint16_t * a, uint16_t * b); 
extern void uint16_sub(uint16_t * a, uint16_t * b);
extern void uint16_mul(uint16_t * a, uint16_t * b);
extern void uint16_div(uint16_t * a, uint16_t * b);
extern void uint16_mod(uint16_t * a, uint16_t * b);
extern void uint16_lt(uint16_t * a, uint16_t * b);
extern void uint16_gt(uint16_t * a, uint16_t * b);
extern void uint16_eq(uint16_t * a, uint16_t * b);
extern void uint16_neq(uint16_t * a, uint16_t * b);
extern void uint16_neq(uint16_t * a, uint16_t * b);
extern void uint16_lteq(uint16_t * a, uint16_t * b);
extern void uint16_gteq(uint16_t * a, uint16_t * b);
extern void uint16_and(uint16_t * a, uint16_t * b);
extern void uint16_or(uint16_t * a, uint16_t * b);
extern void uint16_not(uint16_t * a);
extern void uint16_lsh(uint16_t * a, uint16_t * b);
extern void uint16_rsh(uint16_t * a, uint16_t * b);
extern void uint16_b_and(uint16_t * a, uint16_t * b);
extern void uint16_b_or(uint16_t * a, uint16_t * b);
extern void uint16_b_not(uint16_t * a);
extern void uint16_b_xor(uint16_t * a, uint16_t * b);    
extern void uint16_lval(uint16_t * a, uint16_t * b);   
extern void uint16_rval(uint16_t * a, uint16_t * b);   

extern void int16_add(int16_t * a, int16_t * b);
extern void int16_sub(int16_t * a, int16_t * b); 
extern void int16_mul(int16_t * a, int16_t * b);
extern void int16_div(int16_t * a, int16_t * b); 
extern void int16_mod(int16_t * a, int16_t * b);
extern void int16_lt(int16_t * a, int16_t * b); 
extern void int16_gt(int16_t * a, int16_t * b);
extern void int16_eq(int16_t * a, int16_t * b); 
extern void int16_neq(int16_t * a, int16_t * b);
extern void int16_neq(int16_t * a, int16_t * b);
extern void int16_lteq(int16_t * a, int16_t * b);
extern void int16_gteq(int16_t * a, int16_t * b);
extern void int16_and(int16_t * a, int16_t * b);
extern void int16_or(int16_t * a, int16_t * b);  
extern void int16_not(int16_t * a);
extern void int16_lsh(int16_t * a, int16_t * b);
extern void int16_rsh(int16_t * a, int16_t * b);
extern void int16_b_and(int16_t * a, int16_t * b);
extern void int16_b_or(int16_t * a, int16_t * b);
extern void int16_b_not(int16_t * a);
extern void int16_b_xor(int16_t * a, int16_t * b); 
extern void int16_lval(int16_t * a, int16_t * b);
extern void int16_rval(int16_t * a, int16_t * b);

extern void int8_add(int8_t * a, int8_t * b);  
extern void int8_sub(int8_t * a, int8_t * b);  
extern void int8_mul(int8_t * a, int8_t * b);  
extern void int8_div(int8_t * a, int8_t * b);  
extern void int8_mod(int8_t * a, int8_t * b);  
extern void int8_lt(int8_t * a, int8_t * b);  
extern void int8_gt(int8_t * a, int8_t * b);  
extern void int8_eq(int8_t * a, int8_t * b);  
extern void int8_neq(int8_t * a, int8_t * b);  
extern void int8_neq(int8_t * a, int8_t * b);  
extern void int8_lteq(int8_t * a, int8_t * b);  
extern void int8_gteq(int8_t * a, int8_t * b);  
extern void int8_and(int8_t * a, int8_t * b);  
extern void int8_or(int8_t * a, int8_t * b);  
extern void int8_not(int8_t * a);  
extern void int8_lsh(int8_t * a, int8_t * b);  
extern void int8_rsh(int8_t * a, int8_t * b);  
extern void int8_b_and(int8_t * a, int8_t * b);  
extern void int8_b_or(int8_t * a, int8_t * b);  
extern void int8_b_not(int8_t * a);  
extern void int8_b_xor(int8_t * a, int8_t * b);  
extern void int8_lval(int8_t * a, int8_t * b);  
extern void int8_rval(int8_t * a, int8_t * b);  

extern void uint8_add(uint8_t * a, uint8_t * b);    
extern void uint8_sub(uint8_t * a, uint8_t * b);    
extern void uint8_mul(uint8_t * a, uint8_t * b);    
extern void uint8_div(uint8_t * a, uint8_t * b);    
extern void uint8_mod(uint8_t * a, uint8_t * b);    
extern void uint8_lt(uint8_t * a, uint8_t * b);    
extern void uint8_gt(uint8_t * a, uint8_t * b);    
extern void uint8_eq(uint8_t * a, uint8_t * b);    
extern void uint8_neq(uint8_t * a, uint8_t * b);    
extern void uint8_neq(uint8_t * a, uint8_t * b);    
extern void uint8_lteq(uint8_t * a, uint8_t * b);    
extern void uint8_gteq(uint8_t * a, uint8_t * b);    
extern void uint8_and(uint8_t * a, uint8_t * b);    
extern void uint8_or(uint8_t * a, uint8_t * b);    
extern void uint8_not(uint8_t * a);  
extern void uint8_lsh(uint8_t * a, uint8_t * b);    
extern void uint8_rsh(uint8_t * a, uint8_t * b);    
extern void uint8_b_and(uint8_t * a, uint8_t * b);    
extern void uint8_b_or(uint8_t * a, uint8_t * b);    
extern void uint8_b_not(uint8_t * a);  
extern void uint8_b_xor(uint8_t * a, uint8_t * b);  
extern void uint8_lval(uint8_t * a, uint8_t * b);    
extern void uint8_rval(uint8_t * a, uint8_t * b);    


#endif /* _MACHINE_CODE_H */
