#ifndef _SYSCALLS_H
#define _SYSCALLS_H

/**
 * Copyright (C) 2005 Matthew William Coan
 *
 * System call wrappers (NASM).
 *
 * Author: Matthew W. Coan
 * Mon Nov 28 22:02:38 EST 2005
 */

#ifdef __cplusplus
extern "C" {
#endif

#define STDOUT_FILENO 1
#define STDIN_FILENO 0
#define ssize_t int
#define size_t unsigned int
#define O_RDONLY 00
#define O_WRONLY 01
#define O_RDWR 02
#define O_CREAT 0100
#define O_TRUNC 01000
#define O_APPEND 02000
#define NULL ((void*)0)

extern ssize_t open(const char * filename, int flags, int mode);
extern int unlink(const char * pathname);
extern ssize_t read(unsigned int fd, char * buf, size_t count);
extern ssize_t write(unsigned int fd, const char * buf, size_t count);
extern ssize_t close(unsigned int fd);
extern void exit(int status);
typedef void (*__sighandler_t)(int);
extern unsigned long signal(int sig, __sighandler_t handler);
extern void bzero(void * p, size_t size);

ssize_t writen(int fd, const void * vptr, size_t n);
ssize_t readline(int fd, void * vptr, size_t maxlen);

#ifdef __cplusplus
}
#endif

#endif /* _SYSCALLS_H */
