#include <iostream>
#include <fstream>

#include <string>
#include <list>

#include <ctime>

#include "cgi.h"
#include "csv.h"

#include "config.h"

using namespace std;
using namespace csv_reader;

#define CHAT_FILE "chatroom.txt"

#define CHAT_URI URL_VALUE

#define MAX_MESSAGES 10

class message {
public:
   string name;
   string data;
   string date;

   message() { }
   message(const message & msg) { name = msg.name; data = msg.data; date = msg.date; }
   message(const string & the_name, 
           const string & the_data, 
           const string & the_date) { name = the_name; data = the_data; date = the_date; }
   virtual ~message() { }

   message & operator=(const message & right) {
      name = right.name;
      data = right.data;
      date = right.date;
      return *this;
   }
};

typedef list< message* > message_list_type;

string
csv(const string & str)
{
   string ret;

   for(size_t i = 0; i < str.size(); i++) {
      if(str[i] == '\"') {
         ret += "\"\"";
      }
      else {
         ret += str[i];
      }
   }

   return ret;
}

string
html(const string & str)
{
   string ret;

   for(size_t i = 0; i < str.size(); i++) {
      if(str[i] == '<') {
         ret += "&lt;";
      }
      else if(str[i] == '\"') {
         ret += "&quot;";
      }
      else if(str[i] == '&') {
         ret += "&amp;";
      }
      else {
         ret += str[i];
      }
   }

   return ret;
}

int
main(int argc,
     char ** argv,
     char ** envp)
{
   int ret = 0;

   CGI form_data;

   bool embed = true;

   if(form_data["embed"] != 0) {
      embed = true;
   }

   if(embed == false) {
      cout << "Content-type: text/html\r\n\r\n" << flush;
   }

   const char * name = "";

   if(form_data["name"] && form_data["message"]) {
      name = form_data["name"];
      const char * message = form_data["message"];
      time_t t = time(NULL);
      char * date = ctime(&t);
      size_t sz = strlen(date);
      if(sz > 0) {
         date[sz-1] = 0; 
      }

      if(strlen(name) > 0 && strlen(message)) {
         ofstream fout(CHAT_FILE, ios::app);

         if(fout) {
            fout << "\"" << csv(html(name)) << "\",\"" << csv(html(message)) << "\",\"" << csv(html(date)) << "\"" << endl << flush;
            fout.close();
         }
      }
   }

   //if(embed == false) {
      cout << "<HTML>" << endl
           << "<HEAD>" << endl
           << "<link rel=\"stylesheet\" href=\"/~mcoan/style.css\">" << endl
           << "<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"/~mcoan/lib/site.js\"></SCRIPT>" << endl
           << "</HEAD>" << endl
           << "<BODY BGCOLOR=\"WHITE\">" << endl << flush;
      cout << "<B>Matt's Chat Room</B>" << endl << flush;
      cout << "<BR><HR><BR>" << endl << flush;
      cout << "<FORM METHOD=\"GET\" ACTION=\"/~mcoan/index.php\">" << endl
           << "<INPUT TYPE=\"HIDDEN\" NAME=\"page\" VALUE=\"/~mcoan/chat.php\">" << endl
           << "Name: <INPUT SIZE=\"30\" TYPE=\"TEXT\" NAME=\"name\" VALUE=\"" << name << "\"><BR>" << endl
           << "Message: " << endl
           << "<INPUT SIZE=\"30\" TYPE=\"TEXT\" NAME=\"message\"><BR>" << endl
           << "<INPUT TYPE=\"SUBMIT\" VALUE=\"Send\"> * <INPUT TYPE=\"RESET\" VALUE=\"Clear\">" << endl
           << "</FORM>" << endl << flush;

      cout << "<FORM METHOD=\"GET\" ACTION=\"/~mcoan/index.php\">" << endl
           << "<INPUT TYPE=\"HIDDEN\" NAME=\"page\" VALUE=\"/~mcoan/chat.php\">" << endl
           //<< "<INPUT TYPE=\"SUBMIT\" VALUE=\"Refresh\">" << endl
           << "<INPUT TYPE=\"BUTTON\" onClick=\"updateDivTag();\" VALUE=\"Refresh\">" << endl
           << "</FORM>" << endl << flush;

      cout << "<BR><HR><BR>" << endl << flush;
   //}

   message_list_type msg_list;

   csv_row_type csv_row;

   ifstream fin(CHAT_FILE, ios::in);

   if(fin) {
      while(fin >> csv_row) {
         if(csv_row.size() == 3) {
            msg_list.push_back(new message(csv_row[0], csv_row[1], csv_row[2]));
         }
      }

      fin.close();

      if(embed == false) {
         cout << "<DIV ID=\"oDiv\">" << endl << flush;
      }
      for(message_list_type::reverse_iterator p =  msg_list.rbegin(); p != msg_list.rend(); p++) {
         cout << "<I><B>" << ((*p)->name) << "</B>:</I> " << ((*p)->data) << "<BR><I>" << endl
              << ((*p)->date) << "</I><BR><BR><HR><BR>" << endl 
              << endl << flush;
      }
      if(embed == false) {
         cout << "</DIV>" << endl << flush;
      }
   }
   else {
      cout << "<H1>I/O ERROR...</H1>" << endl;
   }

   if(embed == false) {
      cout << "<SCRIPT LANGUAGE=\"JavaScript\">" << endl << flush;
      cout << "function GetXmlHttpObject() {" << endl;
      cout << "\tif(window.XMLHttpRequest) {" << endl;
      cout << "\t\treturn new XMLHttpRequest();" << endl;
      cout << "\t}" << endl;
      cout << "\tif(window.ActiveXObject) {" << endl;
      cout << "\treturn new ActiveXObject(\"Microsoft.XMLHTTP\");" << endl;
      cout << "\t}" << endl;
      cout << "\treturn null;" << endl;
      cout << "}" << endl;

      cout << "function updateDivTag() {" << endl << flush;
      cout << "\tvar xmlhttp = GetXmlHttpObject();" << endl << flush;
      cout << "\txmlhttp.open(\"GET\", \"/~mcoan/chat.php?embed=true\",false);" << endl << flush;
      cout << "\txmlhttp.send('');" << endl << flush;
      cout << "\toDiv.innerHTML = xmlhttp.responseText;" << endl << flush;
      cout << "\tsetTimeout(\"updateDivTag();\", 1000);" << endl << flush;
      cout << "}" << endl << flush;
      cout << "setTimeout(\"updateDivTag();\", 1000);" << endl << flush;
      cout << "</SCRIPT>" << endl << flush;

      cout << "<FORM METHOD=\"GET\" ACTION=\"" << CHAT_URI << "\">" << endl
           //<< "<INPUT TYPE=\"HIDDEN\" NAME=\"page\" VALUE=\"chat\">" << endl
           << "Name: <INPUT SIZE=\"30\" TYPE=\"TEXT\" NAME=\"name\" VALUE=\"" << name << "\"><BR>" << endl
           << "Message: " << endl
           << "<INPUT SIZE=\"30\" TYPE=\"TEXT\" NAME=\"message\"><BR>" << endl
           << "<INPUT TYPE=\"SUBMIT\" VALUE=\"Send\"> * <INPUT TYPE=\"RESET\" VALUE=\"Clear\">" << endl
           << "</FORM>" << endl << flush;

      cout << "<FORM METHOD=\"GET\" ACTION=\"" << CHAT_URI << "\">" << endl
           //<< "<INPUT TYPE=\"HIDDEN\" NAME=\"page\" VALUE=\"chat\">" << endl
           //<< "<INPUT TYPE=\"SUBMIT\" VALUE=\"Refresh\">" << endl
           << "<INPUT TYPE=\"BUTTON\" onClick=\"updateDivTag();\" VALUE=\"Refresh\">" << endl
           << "</FORM>" << endl << flush;

      cout << "<BR><HR><BR>" << endl << flush;
   }


   if(embed == false) {
      cout << "</BODY>" << endl
           << "</HTML>" << endl << flush;
   }   

   if(msg_list.size() >= MAX_MESSAGES) {
      delete (msg_list.front());

      msg_list.pop_front();

      ofstream fout(CHAT_FILE, ios::trunc);

      if(fout) {
         for(message_list_type::iterator p = msg_list.begin(); p != msg_list.end(); p++) {
            fout << "\"" << csv((*p)->name) << "\",\"" << csv((*p)->data) << "\",\"" 
                 << csv((*p)->date) << "\"" << endl << flush;
         }

         fout.close();
      }
   }

   for(message_list_type::iterator p =  msg_list.begin(); p != msg_list.end(); p++) {
      delete (*p);
   }

   msg_list.clear();

   return ret;
}

