#include <iostream>
#include <fstream>
#include <string>

#include <cstdlib>
#include <cstring>

#include <unistd.h>
#include <sys/types.h>
#include <signal.h>

#include "tcp_stream.h"
#include "tcp_server.h"

#define CHAT_FILE "/home/mcoan/public_html/cgi-bin/chat_room.txt"
#define CHAT_PORT 8080
#define CHAT_HOST "127.0.0.1"
#define TIMEOUT 60

using namespace std;
using namespace net_tools;

tcp_server * p_svr = 0;

struct chatd_exception { };

inline
int
System(const string & str) 
{
   return system(str.c_str());
}

class chatd {
   bool read_line(string & line, tcp_stream & ts) {
      bool ret = false;
      char ch;
      ch = ts.get();
      while(ts) {
cerr << ch;
         ret = true;
         line += ch;
         if(ch == '\n') break;
         ch = ts.get();
      }
      return ret;
   }

   void read_request(tcp_stream & ts) {
      string line;
      while(read_line(line, ts)) {
         if(line == "\r\n" || line == "\n") break;
         line = "";
      }
   }

   void send_response(tcp_stream & ts) {
      putenv((char*)"REQUEST_METHOD=GET");
      putenv((char*)"QUERY_STRING=embed=true");
      System("./chat.cgi > temp.txt");
      ifstream fin("temp.txt", ios::in);
      string data;
      if(fin) {
         char ch;
         ch = fin.get();
         while(fin) {
            data += ch;
            ch = fin.get();
         }
         fin.close();
      }
cerr << "CONTENT_LENGTH=" << data.size() << endl;
      ts << "HTTP/1.0 200 OK\r\n";
      ts << "Content-length: " << (int)data.size() << "\r\n";
      ts << "Connection: close\r\n";
      ts << "Content-type: text/html\r\n\r\n";
      ts << data;
   }
   
public:
   void run() {
      cerr << "RUN..." << endl;
      tcp_server svr(CHAT_HOST, CHAT_PORT);
      p_svr = &svr;
      //alarm(TIMEOUT);
      int fd = svr.accept();
      while(fd > 0) {
         //alarm(TIMEOUT);
         tcp_stream ts(fd);
         cout << "ACCEPT..." << endl;
         read_request(ts);
         send_response(ts);
         ts.close();
         fd = svr.accept();
      }
      //alarm(0);
      svr.close();
   }
};

void
on_SIGNAL(int arg)
{
  if(arg == SIGALRM || arg == SIGHUP) {
     cerr << "DIE..." << endl;
     exit(0);
  }
  if(arg == SIGINT || arg == SIGTERM || arg == SIGHUP) {
     cerr << "DIE..." << endl;
     p_svr->close();
     exit(0);
  }
}

int
main(int argc, char ** argv)
{
   for(size_t i = 1; i < argc; i++) {
      if(strcmp(argv[i], "-daemon") == 0) {
         daemon(0,0);
         break;
      }
   }

   signal(SIGALRM, on_SIGNAL);
   signal(SIGTERM, on_SIGNAL);
   signal(SIGINT, on_SIGNAL);
   signal(SIGHUP, on_SIGNAL);

   try {
      chatd the_chatd;
      the_chatd.run();
   }
   catch(...) {
      cerr << "exception..." << endl;
   }

   return 0;
}
