//
// THE CLIENT:
// You must link in the ws2_32.lib library (MVC++ 6.0).
// Matthew W. Coan
//

#include "stdafx.h"
#include <winsock2.h>
#include <stdio.h>
#include <assert.h>

WSADATA stWSAData;  // WinSock DLL Info.

#define WSA_MAJOR_VERSION 1
#define WSA_MINOR_VERSION 1
#define WSA_VERSION MAKEWORD(WSA_MAJOR_VERSION, WSA_MINOR_VERSION)

//
// Echo lines of text back and forth between 
// the client and the server.  
//
void
Echo(SOCKET sock)
{
   const size_t BUF_SZ = 1024;
   char buf[BUF_SZ];

   // Forever:
   while(true) {
      // Get a line of text from the user.
      memset(buf, 0, BUF_SZ);
      fgets(buf, BUF_SZ - 1, stdin);
     
	  // Send the text to the server.
	  send(sock, buf, BUF_SZ, 0);

	  // Read a line of text back from the server.
	  memset(buf, 0, BUF_SZ);
      recv(sock, buf, BUF_SZ, 0);

	  // Show the read line of text to the user.
      fprintf(stdout, "%s", buf);
      fflush(stdout);
   }
}

// 
// Main entry point.
//
int
main()
{
   SOCKET sock;     // Socket descriptor.
   sockaddr_in svr; // Server address info.
   int n;

   // Load the winsock DLL into our address space.
   WSAStartup(WSA_VERSION, &stWSAData); 

   // Create the socket.
   sock = socket(AF_INET, SOCK_STREAM, 0);

   // Check for an error.
   assert(sock >= 0);

   // Write zero's into the address info.
   memset(reinterpret_cast< char* >(&svr), 0, sizeof(svr));


   HOSTENT * ph = gethostbyname("www.microsoft.com");
   if(ph == NULL) {
      closesocket(sock);
      return 0;
   }

   svr.sin_family = AF_INET;
   memcpy(&svr.sin_addr, 
          ph->h_addr_list[0], 
          sizeof(struct in_addr));
   svr.sin_port = htons(80);

   // Connect to the server.
   n = connect(sock, reinterpret_cast< const sockaddr* >(&svr), sizeof(svr));

   // Check for an error.
   assert(n >= 0);

   fprintf(stdout, "Connected...");
   fflush(stdout);

   // Echo strings back and forth.
   Echo(sock);

   closesocket(sock);

   return 0;
}