/**************** CLIST IMPLAMENTATION ************/
#include "CList.h"
#include "_assert.h"

/* Create node operation. */
CListNode * CListNodeCreate ( void * dataPtr,
                              CListNode * nextPtr,
                              CListNode * prevPtr )
{
   CListNode * n;

   n = ( CListNode * ) malloc ( sizeof ( CListNode ) );
   Assert(n != NULL);
   n->next = nextPtr;
   n->prev = prevPtr;
   n->data = dataPtr;

   return n;
}

/* Destroy node operation. */
void CListNodeDestroy ( CListNode * n, void ( * pDestroyData ) ( void * ) )
{
   if ( n->data != NULL )
      ( * pDestroyData ) ( n->data );
   n->data = NULL;
   free( ( void * ) n );
}

/* Construct operation. */
CList * CListCreate ( void ( * pDestroy ) ( void * ) ) {
   CList * l;

   l = ( CList * ) malloc ( sizeof ( CList ) );
   Assert(l != NULL);

   l->head = CListNodeCreate ( NULL, NULL, NULL );
   l->head->next = l->head;
   l->head->prev = l->head;
   l->size = 0;
   l->pDestroyData = pDestroy;

   return l;
}

/* List destory operation. */
void CListDestroy ( CList * l ) {

   if ( l != NULL ) {

      while ( ! CListIsEmpty ( l ) ) {
         CListPopHead( l );
      }

      free( ( void * ) l->head );
      free( ( void * ) l );
   }
}

/* Clear all nodes operation. */
void CListClear ( CList * l ) {

   while ( ! CListIsEmpty ( l ) ) {
      CListPopHead( l );
   }

   l->size = 0;
   l->head->next = l->head;
   l->head->prev = l->head;
}

/* Push an element on the head of a list. */
void CListPushHead ( CList * l, void * dataPtr ) {
   CListNode * n;

   n = CListNodeCreate ( dataPtr, l->head->next, l->head );
   l->head->next->prev = n;
   l->head->next = n;
   l->size++;
}

/* Push an element on the tail of a list. */
void CListPushTail ( CList * l, void * dataPtr ) {
   CListNode * n;

   n = CListNodeCreate ( dataPtr, l->head, l->head->prev );
   l->head->prev->next = n;
   l->head->prev = n;   
   l->size++;
}

/* Remove the head of the list. */
void CListPopHead ( CList * l ) {
   CListNode * n;

   n = l->head->next;
   l->head->next = n->next;
   n->next->prev = l->head->next;

   l->size--;

   CListNodeDestroy ( n, l->pDestroyData );
}

/* Remove the tail of the list. */
void CListPopTail ( CList * l ) {
   CListNode * n;

   n = l->head->prev;
   l->head->prev = n->prev;
   n->prev->next = l->head->prev;
   l->size--;

   CListNodeDestroy ( n, l->pDestroyData );
}

/* Apply a function to every data pointer in a list. */
void CListForEachHtoT ( CList * l, void ( * proc ) ( void * ) ) {
   CListNode * n;

   n = l->head->next;
   
   while ( n != l->head ) {
      ( * proc ) ( n->data );
      n = n->next;
   }
}

/* Apply a function to every data pointer in a list. */
void CListForEachTtoH ( CList * l, void ( * proc ) ( void * ) ) {
   CListNode * n;

   n = l->head->prev;

   while ( n != l->head ) {
      ( * proc ) ( n->data );
      n = n->prev;
   }
}     

