#include "coff.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <iostream>
#include <fstream>

using namespace std;

#define  YESNO(x) (x?"yes":"no")


/*******************************************************************
Name:          coffinfo.c

Autor:         www.c-worker.ch

Beschreibung:  Zeigt Informationen ber eine Datei im
               coff Objekt Format an.

Plattform:     Dos/Win/Linux(?)/.. sollte eigentlich auf jedem OS
               mit den Standard C-libs kompilierbar sein.

Wichtig:       coff.h liegt dabei (vom DJGPP compiler..), hast du
               jedoch ein eigenes coff.h welches mit deinem compiler kommt,
               solltest du AUF JEDEN FALL dieses verwenden.
               Dazu einfach die erste Zeile in #include <coff.h> ndern.
               Am besten erst mal so (mit #include <coff.h>) probieren.

-------------------------------------------------------------------

CWCoffInfo 0.01 B                                                   
Copyright (C) 2001 www.c-worker.ch

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

********************************************************************/

void usage(void);

int main(int argc, char** argv)
{
  FILE *coffFile;
  char buf[256];
  unsigned long currSect,nrSect=0;
  unsigned long flags=0x00000000;
  long rc;

  if(argc<3)
    usage();

  if(!(coffFile=fopen(argv[1],"r")))
  {
    printf("Error: Cannot open File %s\n",argv[1]);
    exit(0);
  }

  /*
  * File Header..
  */
  rc=fread(buf,1,FILHSZ,coffFile);
  if(rc<FILHSZ)
  {
    printf("Error while reading the File\n");
    exit(0);
  }
  if(I386BADMAG(*((FILHDR*)buf)))
  {
    printf("Error: no coff File\n");
    exit(0);
  }
  nrSect=((FILHDR*)buf)->f_nscns;
  flags=((FILHDR*)buf)->f_flags;

  cout << "Number of Sections: " << nrSect << endl << flush;

/*
  printf("\n\nFile Header:\n"
         "***********************************************\n"
         "Number of Sections:          %d\n"
         "Timestamp:                   %s\n"
         "Number of Symtab entries:    %d\n"
         "Size of optional Header:     %d\n"
         ,nrSect,ctime(&((FILHDR*)buf)->f_timdat),((FILHDR*)buf)->f_nsyms, ((FILHDR*)buf)->f_opthdr);
  printf("\nFlags:\n"
         "-Relocations in File:        %s\n"
         "-Executeble File:            %s\n"
         "-No Line Number Information: %s\n"
         "-Local Symbols removed:      %s\n"
         "-32 Bit Little Endian File:  %s\n"
         ,YESNO(flags&F_RELFLG)
         ,YESNO(flags&F_EXEC)
         ,YESNO(flags&F_LNNO)
         ,YESNO(flags&F_LSYMS)
         ,YESNO(flags&0x0100));
*/

  /*
  * Optionaler Header..
  */
  if(((FILHDR*)buf)->f_opthdr>0)
  {
    if(((FILHDR*)buf)->f_opthdr==sizeof(GNU_AOUT))
    {
      rc=fread(buf,1,sizeof(GNU_AOUT),coffFile);
      if(rc<sizeof(GNU_AOUT))
      {
        printf("Error while reading the File\n");
        exit(0);
      }
      printf("\nOptional GNU-aout Header:\n"
      "-Entry Point: %d\n"
      ,((GNU_AOUT*)buf)->entry);
    }
    else if(((FILHDR*)buf)->f_opthdr==AOUTSZ)
    {
      rc=fread(buf,1,AOUTSZ,coffFile);
      if(rc<AOUTSZ)
      {
        printf("Error while reading the File\n");
        exit(0);
      }
      printf("\nOptional aout Header:\n"
      "-Entry Point: %d\n"
      ,((AOUTHDR*)buf)->entry);
    }
    else
    {
      printf("\nUnknown optional Header..\n");
    }
  }

  char * filename = "a.out";

  if(argc == 3) {
     filename = argv[2];
  }
  
  fstream output(filename, ios::out | ios::binary);

  if(!output) {
     cerr << "unable to open output file: " << filename << endl;

     exit(1);
  }

  unsigned int magic_number = 0xCAFEBABE;

  output.seekg(0, ios::beg);

  output.clear();

  output.write(reinterpret_cast< char* >(&magic_number), 
               sizeof(unsigned int));

  output.flush();

  unsigned int main_address = 0;

  unsigned int address = static_cast< unsigned int >(output.tellg());

  output.write(reinterpret_cast< char* >(&main_address),
               sizeof(unsigned int));

  output.flush();

  /*
  * Secitons...
  */
  for(currSect=0;currSect<nrSect;currSect++)
  {
    rc=fread(buf,1,SCNHSZ,coffFile);
    long addr = ftell(coffFile);

    if(rc<SCNHSZ)
    {
      printf("Error while reading the File\n");
      exit(0);
    }
    flags=((SCNHDR*)buf)->s_flags;

    cout << "Section Name: \"" << (((SCNHDR*)buf)->s_name) << "\"" 
         << endl << flush;
    cout << "Phisical Address: " << (((SCNHDR*)buf)->s_paddr) 
         << endl << flush;
    cout << "Section Size: " << (((SCNHDR*)buf)->s_size)
         << endl << flush;

    bool in_code = false;

    if(strcmp((((SCNHDR*)buf)->s_name), ".text") == 0) {
        main_address = ((SCNHDR*)buf)->s_paddr;

        in_code = true;
    }

    char ch;

    output.seekg(0, ios::end);

    fseek(coffFile, (((SCNHDR*)buf)->s_paddr), SEEK_SET);

    for(int z = 0; z < (((SCNHDR*)buf)->s_size); z++) {
       fread(&ch, 1, 1, coffFile);

       output.write(&ch, 1);
    }

    output.flush();

    output.seekg(sizeof(unsigned int), ios::beg);

    if(in_code) {
       output.write(reinterpret_cast< char* >(&main_address),
                    sizeof(unsigned int));

       output.flush();
    }

/*
    printf("\n\nSection %s:\n"
    "***********************************************\n"
    "Physical Adress:                 %d\n"
    "Virtual Adress:                  %d\n"
    "Section Size:                    %d\n"
    "Relocation entries:              %d\n"
    "Line number entries:             %d\n"
    ,((SCNHDR*)buf)->s_name
    ,((SCNHDR*)buf)->s_paddr
    ,((SCNHDR*)buf)->s_vaddr
    ,((SCNHDR*)buf)->s_size
    ,((SCNHDR*)buf)->s_nreloc
    ,((SCNHDR*)buf)->s_nlnno
    );

    printf("\nFlags:\n"
    "-contains only executable code:  %s\n"
    "-contains only initialized data: %s\n"
    "-defines uninitialized data,\n"
    " and has no data stored in the\n"
    " coff file for it:               %s\n"
    ,YESNO(flags&STYP_TEXT)
    ,YESNO(flags&STYP_DATA)
    ,YESNO(flags&STYP_BSS));
*/

     fseek(coffFile, addr, SEEK_SET);
  }
  output.flush();
  output.close();
  fclose(coffFile);
  return 0;
}

void usage()
{
  printf("Usage: ./coff-linker <coff-file> <output-program>\n");
  exit(0);
}
