#include "coff.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define  YESNO(x) (x?"yes":"no")


/*******************************************************************
Name:          coffinfo.c

Autor:         www.c-worker.ch

Beschreibung:  Zeigt Informationen ber eine Datei im
               coff Objekt Format an.

Plattform:     Dos/Win/Linux(?)/.. sollte eigentlich auf jedem OS
               mit den Standard C-libs kompilierbar sein.

Wichtig:       coff.h liegt dabei (vom DJGPP compiler..), hast du
               jedoch ein eigenes coff.h welches mit deinem compiler kommt,
               solltest du AUF JEDEN FALL dieses verwenden.
               Dazu einfach die erste Zeile in #include <coff.h> ndern.
               Am besten erst mal so (mit #include <coff.h>) probieren.

-------------------------------------------------------------------

CWCoffInfo 0.01 B                                                   
Copyright (C) 2001 www.c-worker.ch

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

********************************************************************/

void usage(void);

int main(int argc, char** argv)
{

/*
File Header:
***********************************************
Number of Sections:          2
Timestamp:                   1352166183
Number of Symtab entries:    8
Size of optional Header:     0

Flags: 260


Section .data:
***********************************************
Physical Adress:                 0
Virtual Adress:                  0
Section Size:                    0
Relocation entries:              0
Line number entries:             0

Flags: 64


Section .text:
***********************************************
Physical Adress:                 0
Virtual Adress:                  0
Section Size:                    21
Relocation entries:              0
Line number entries:             0

Flags: 32

*/
  FILHDR hdr;
  SCNHDR shdr;
  FILE *coffFile;
  char buf[256];
  unsigned long currSect,nrSect=0;
  unsigned long flags=0x00000000;
  long rc;
  const char data[] = ".data";
  const char text[] = ".text";
  const size_t code_size = 182;
  char code[code_size];
  FILE * f2;
  int count;
  char ch;

  if(argc<2)
    usage();
  if(!(coffFile=fopen(argv[1],"w")))
  {
    printf("Error: Cannot open File %s\n",argv[1]);
    exit(0);
  }

  memset((void*)&hdr, 0, FILHSZ);
  hdr.f_magic = I386MAGIC;
  hdr.f_nscns = 2;
  hdr.f_flags = 260;
  hdr.f_timdat = 1352166183;
  hdr.f_nsyms = 8;
  hdr.f_opthdr = 0;
  fwrite(&hdr,1,FILHSZ,coffFile);
  fflush(coffFile);

  memset((void*)&shdr, 0, SCNHSZ);
  strcpy(shdr.s_name, data);
  shdr.s_paddr = 0;
  shdr.s_vaddr = 0;
  shdr.s_size = 0;
  shdr.s_nreloc = 0;
  shdr.s_nlnno = 0;
  shdr.s_flags = 64;
  fwrite(&shdr,1,SCNHSZ,coffFile);
  fflush(coffFile);

  memset((void*)&shdr, 0, SCNHSZ);
  strcpy(shdr.s_name, text);
  shdr.s_paddr = 0;
  shdr.s_vaddr = 0;
  shdr.s_size = 21;
  shdr.s_nreloc = 0;
  shdr.s_nlnno = 0;
  shdr.s_flags = 32;
  fwrite(&shdr,1,SCNHSZ,coffFile);
  fflush(coffFile);

  f2 = fopen("data.dat", "r");
  count = 0;
  fread(&ch,1,1,f2);
  while(!feof(f2)) {
    code[count] = ch;
    count++;
    fread(&ch,1,1,f2);
  }
  fclose(f2);

  /*memset(code,0,code_size);*/
  fwrite(code,1,count,coffFile);
  fflush(coffFile);

  fclose(coffFile);

/*
    rc=fread(buf,1,SCNHSZ,coffFile);
    if(rc<SCNHSZ)
    {
      printf("Error while reading the File\n");
      exit(0);
    }
    flags=((SCNHDR*)buf)->s_flags;

    printf("\n\nSection %s:\n"
    "***********************************************\n"
    "Physical Adress:                 %d\n"
    "Virtual Adress:                  %d\n"
    "Section Size:                    %d\n"
    "Relocation entries:              %d\n"
    "Line number entries:             %d\n"
    ,((SCNHDR*)buf)->s_name
    ,((SCNHDR*)buf)->s_paddr
    ,((SCNHDR*)buf)->s_vaddr
    ,((SCNHDR*)buf)->s_size
    ,((SCNHDR*)buf)->s_nreloc
    ,((SCNHDR*)buf)->s_nlnno
    );

    printf("\nFlags: %d\n", flags);
  }


  rc=fread(buf,1,FILHSZ,coffFile);
  if(rc<FILHSZ)
  {
    printf("Error while reading the File\n");
    exit(0);
  }
  if(I386BADMAG(*((FILHDR*)buf)))
  {
    printf("Error: no coff File\n");
    exit(0);
  }
  nrSect=((FILHDR*)buf)->f_nscns;
  flags=((FILHDR*)buf)->f_flags;

  printf("\n\nFile Header:\n"
         "***********************************************\n"
         "Number of Sections:          %d\n"
         "Timestamp:                   %d\n"
         "Number of Symtab entries:    %d\n"
         "Size of optional Header:     %d\n"
         ,nrSect,((FILHDR*)buf)->f_timdat,((FILHDR*)buf)->f_nsyms, ((FILHDR*)buf)->f_opthdr);
  printf("\nFlags: %d\n", flags);

  if(((FILHDR*)buf)->f_opthdr>0)
  {
    if(((FILHDR*)buf)->f_opthdr==sizeof(GNU_AOUT))
    {
      rc=fread(buf,1,sizeof(GNU_AOUT),coffFile);
      if(rc<sizeof(GNU_AOUT))
      {
        printf("Error while reading the File\n");
        exit(0);
      }
      printf("\nOptional GNU-aout Header:\n"
      "-Entry Point: %d\n"
      ,((GNU_AOUT*)buf)->entry);
    }
    else if(((FILHDR*)buf)->f_opthdr==AOUTSZ)
    {
      rc=fread(buf,1,AOUTSZ,coffFile);
      if(rc<AOUTSZ)
      {
        printf("Error while reading the File\n");
        exit(0);
      }
      printf("\nOptional aout Header:\n"
      "-Entry Point: %d\n"
      ,((AOUTHDR*)buf)->entry);
    }
    else
    {
      printf("\nUnknown optional Header..\n");
    }
  }


  for(currSect=0;currSect<nrSect;currSect++)
  {
    rc=fread(buf,1,SCNHSZ,coffFile);
    if(rc<SCNHSZ)
    {
      printf("Error while reading the File\n");
      exit(0);
    }
    flags=((SCNHDR*)buf)->s_flags;

    printf("\n\nSection %s:\n"
    "***********************************************\n"
    "Physical Adress:                 %d\n"
    "Virtual Adress:                  %d\n"
    "Section Size:                    %d\n"
    "Relocation entries:              %d\n"
    "Line number entries:             %d\n"
    ,((SCNHDR*)buf)->s_name
    ,((SCNHDR*)buf)->s_paddr
    ,((SCNHDR*)buf)->s_vaddr
    ,((SCNHDR*)buf)->s_size
    ,((SCNHDR*)buf)->s_nreloc
    ,((SCNHDR*)buf)->s_nlnno
    );

    printf("\nFlags: %d\n", flags);
  }
  fclose(coffFile);
*/
  return 0;
}

void usage()
{
  printf("Usage: coffinfo <coff-file>\n");
  exit(0);
}
