/* 

RUN COFF FILE...

Author: Matthew W. Coan
Date: Fri Sep 20 14:28:09 EDT 2013

*/
#include <windows.h>
#undef N_BTMASK
#undef N_BTSHFT
#undef N_TSHIFT
#undef N_TMASK
#undef ISPTR
#undef ISFCN
#undef ISARY
#undef ISTAG
#include "coff.h"
#include "str.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <vector>
#include <map>
#include <fstream>
#include <iostream>
#include <cctype>
//#include "bfsream.h"

using namespace std;
using namespace string_tools;

#define  YESNO(x) (x?"yes":"no")

void usage(void);

typedef int (*pf_t)();

const size_t GOTO_SIZE = 12-5;
const size_t GOTO_OFF = 6-5;
char GOTO32[GOTO_SIZE]= {
-72, 0, 0, 0, 0, 
-1, -32, 
};

class Section;

class Symbol {
public:
   string name;
   size_t address;
   char * pointer;
   bool is_ext;
   Section * sect;
   Symbol() {
     address = 0;
     pointer = 0;
     is_ext = false;
     sect = 0;
   }
};

class Reloc {
public:
  size_t address;
  size_t index;
  Reloc() {
    address = 0;
    index = 0;
  }
};

class Reloc2 {
public:
   size_t address;
   string name;
   Reloc2(const string & name0, size_t address0) {
      address = address0;
      name = name0;
   }
};

class Section {
public:
   string name;
   char * buffer;
   size_t size;
   vector< Reloc* > reloc_vec;
   vector< Reloc2* > reloc_vec2;
   Section() {
     buffer = 0;
     size = 0;
   }
   ~Section() {
     if(buffer) {
        delete [] buffer;
     }
     size_t i;
     for(i = 0; i < reloc_vec.size(); i++) {
        delete reloc_vec[i];
     }
     reloc_vec.clear();
     for(i = 0; i < reloc_vec2.size(); i++) {
        delete reloc_vec2[i];
     }
     reloc_vec2.clear();
   }
   void add_relocation(Reloc * r) {
     reloc_vec.push_back(r);
   }
};

class ObjectCode;

class Linker {
public:
   typedef vector< ObjectCode* > obj_vector_type;
   typedef vector< Symbol* > sym_vector_type;
   typedef vector< void* > dll_vector_type;
private:
   obj_vector_type obj_vec;
   sym_vector_type sym_vec;
   dll_vector_type dll_vec;
   bool verbose;
public:
   Linker();
   ~Linker();
   int run(int argc, char ** argv);
   bool has_symbol(const string & name);
   ObjectCode * get_symbol(const string & name);
   Symbol * get_symbol3(const string & name);
   char * get_symbol_ptr(const string & name, bool search_dll = true);
   void link2();
   friend class ObjectCode;
};

class ObjectCode {
public:
   typedef vector< Section* > section_vector_type;
   typedef vector< Symbol* > symbol_vector_type;
  
private:
   char * sym_tbl;
   int str_length;
   long section_seek;
   long symptr;
   long nsyms;
   fstream coffFile;
   unsigned long nrSect;
   unsigned long flags;
   Section * p_section;
   section_vector_type section_vec;
   symbol_vector_type symbol_vec;
   char * entry_ptr;
   string file_name;
   Linker * linker;
   size_t n_relocate;
   bool verbose;

public:
   ObjectCode(const string & file_name, Linker * ld) {
      verbose = false;
      linker = ld;
      this->file_name = file_name;
      sym_tbl = 0;
      str_length = 0;
      section_seek = 0;
      symptr = 0;
      nsyms = 0;
      nrSect = 0;
      flags = 0;
      p_section = 0;
      entry_ptr = 0;
      n_relocate = 0;
   }

   ~ObjectCode() {
      if(sym_tbl) {
         delete [] sym_tbl;
      }
      size_t i;
      for(i = 0; i < section_vec.size(); i++) {
         delete section_vec[i];
      }
      section_vec.clear();
   }

   const string & get_name() const { return file_name; }

   void read(char * buffer, size_t size) {
      coffFile.read(buffer,size);
      if(coffFile.eof()) {
         coffFile.clear();
      }
   }

   Section * get_section(const string & name) {
      Section * p = 0;
      for(size_t i = 0; i < section_vec.size(); i++) {
         if(strcmp(section_vec[i]->name.c_str(), name.c_str()) == 0) {
            p = section_vec[i];
            break;
         }
      }
      return p;
   }

   char* get_dll_symbol(const string & name);
   const char * get_symbol_name(const unsigned short t);
   const char * get_storage_class(const unsigned short t);
   const char * get_type(unsigned int code);
   void read_file_header();
   void read_strings();
   void read_symbols();
   void read_aout(FILHDR * section);
   void read_header(SCNHDR * section);
   void read_bss(SCNHDR * section);
   void read_data(SCNHDR * section);
   void read_text(SCNHDR * section);
   void read_lineno(SCNHDR * section);
   void read_sections();
   bool has_symbol(const string & str);
   char  * get_symbol(const string & str);
   void scan_extern1(size_t i, map< size_t, size_t > & tbl);
   void scan_extern0(size_t i, map< size_t, size_t > & tbl);
   void load();
   void link();
   void link2();
   void run();
   friend class Linker;
};

char * Linker::get_symbol_ptr(const string & str, bool search_dll) 
{
   char * ret = 0;
   for(size_t i = 0; i < obj_vec.size(); i++) {
      for(size_t j = 0; j < obj_vec[i]->symbol_vec.size(); j++) {
         if(strcmp(obj_vec[i]->symbol_vec[j]->name.c_str(), str.c_str()) == 0) {
            if(obj_vec[i]->symbol_vec[j]->is_ext == false && obj_vec[i]->symbol_vec[j]->pointer != 0) {
               ret = obj_vec[i]->symbol_vec[j]->pointer;
               break;
            }
         }
      }
      if(ret) {
         break;
      }
   }
   if(!ret && search_dll) {
      char * ptr;
      for(size_t i = 0; i < dll_vec.size(); i++) {
         if((ptr=(char*)GetProcAddress((HINSTANCE)dll_vec[i], str.c_str())) != 0) {
            ret = ptr;
            break;
         }
      }
   }
   return ret;
}

char* ObjectCode::get_symbol(const string & name)
{
   Section * p_sect = get_section("text");
   char * ptr = p_sect->buffer;
   size_t i,j;
   Symbol * p_symbol = 0;
   for(i = 0; i < symbol_vec.size(); i++) {
      p_symbol = symbol_vec[i];
      if(p_symbol->name.size() != 0) {
         if(strcmp(p_symbol->name.c_str(),name.c_str()) == 0 && p_symbol->is_ext == false) {
            if(p_symbol->pointer != 0) {
               ptr = p_symbol->sect->buffer+p_symbol->address;
               break;
            }
         }
      }
  }
  return ptr;
}

bool Linker::has_symbol(const string & name)
{
   bool ret = false;
   for(size_t i = 0; i < obj_vec.size(); i++) {
      if(obj_vec[i]->has_symbol(name)) {
         ret = true;
         break;
      }
   }
   return ret;
}

bool ObjectCode::has_symbol(const string & sym)
{
    bool ret = false;
    for(size_t i = 0; i < symbol_vec.size(); i++) {
       if(strcmp(symbol_vec[i]->name.c_str(), sym.c_str()) == 0 
          && symbol_vec[i]->is_ext == false) {
          ret = true;
          break;
       }
    }
    return ret;
}

Linker::Linker()
{
   verbose = false;
}

Linker::~Linker()
{
   size_t i;
   for(i = 0; i < obj_vec.size(); i++) {
      delete obj_vec[i];
   }
   obj_vec.clear();
   for(i = 0; i < dll_vec.size(); i++) {
      CloseHandle(dll_vec[i]);
   }
   dll_vec.clear();
}

void ObjectCode::link2() {
   Section * p_sect;
   Symbol * p_symbol;
   Reloc2 * p_reloc;
   ObjectCode * obj;
   char * ptr;
   for(size_t i = 0; i < section_vec.size(); i++) {
      p_sect = section_vec[i];
      for(size_t j = 0; j < p_sect->reloc_vec2.size(); j++) {
         p_reloc = p_sect->reloc_vec2[j]; 
         obj = linker->get_symbol(p_reloc->name);
         if(obj) {
            ptr = obj->get_symbol(p_reloc->name);
            if(ptr) {
               (*((size_t*)(p_sect->buffer + p_reloc->address))) = (size_t)ptr;
            }
         }
      }
   }
}

void Linker::link2() {
   ObjectCode * obj;
   for(size_t i = 0; i < obj_vec.size(); i++) {
      obj = obj_vec[i];
      obj->link2();
   }
}

void ObjectCode::scan_extern1(size_t i, map< size_t, size_t > & tbl) {
   Reloc * p_reloc = 0;
   Section * p_sect = 0;
   Symbol * p_symbol = 0;
   char * p;
   for(size_t j = 0; j < section_vec[i]->reloc_vec.size(); j++) {
      p_sect = section_vec[i];
      p_reloc = p_sect->reloc_vec[j];
      p_symbol = symbol_vec[p_reloc->index];
      p = (char*)(p_sect->buffer + p_reloc->address);
      if((p>p_sect->buffer)?(*(p-1) == -24):(0)) {
         size_t value = 0xFFFFFFFF - *(size_t*)p;
         (*(size_t*)p) = tbl[value] - ((p+4)-p_sect->buffer);
      }
      else {
         (*(size_t*)p) += (size_t)(p_symbol->pointer);
      }
   }
}

void ObjectCode::scan_extern0(size_t i, map< size_t, size_t > & tbl) {
   Reloc * p_reloc = 0;
   Section * p_sect = 0;
   Symbol * p_symbol = 0;
   char * temp;
   for(size_t j = 0; j < section_vec[i]->reloc_vec.size(); j++) {
      p_sect = section_vec[i];
      p_reloc = p_sect->reloc_vec[j];
      p_symbol = symbol_vec[p_reloc->index];
      if((p_reloc->address)?(p_sect->buffer[p_reloc->address-1] == -24):(false)) {
         size_t index = 0xFFFFFFFF - (0xFFFFFFFF - (p_reloc->address + 4 - 1));
         if(tbl.find(index) == tbl.end()) {
            temp = new char[p_sect->size + (n_relocate * GOTO_SIZE) + GOTO_SIZE];
            memcpy(temp,p_sect->buffer,p_sect->size + (n_relocate * GOTO_SIZE));
            delete [] p_sect->buffer;
            p_sect->buffer = temp;
            if(p_symbol->pointer == 0) {
               char * sym0 = linker->get_symbol_ptr(p_symbol->name);
               if(sym0) {
                  (*(size_t*)(GOTO32+GOTO_OFF)) = (size_t)(sym0);
               }
            }
            else {
               (*(size_t*)(GOTO32+GOTO_OFF)) = (size_t)(p_symbol->pointer);
            }
            p_sect->reloc_vec2.push_back(new Reloc2(p_symbol->name, p_sect->size + (n_relocate * GOTO_SIZE) + GOTO_OFF));
            memcpy(p_sect->buffer+(p_sect->size + (n_relocate * GOTO_SIZE)),GOTO32,GOTO_SIZE);
            tbl[index] = p_sect->size + (n_relocate * GOTO_SIZE);
            n_relocate++;
         }
      }
   }
}

void ObjectCode::link() {
    Reloc * p_reloc = 0;
    Section * p_sect = 0;
    Symbol * p_symbol = 0;
    char * ptr = 0;
    size_t i,j;
    map< size_t, size_t > tbl;
    bool did_invert = false;
    char * p, * temp;
    for(i = 0; i < section_vec.size(); i++) {
        n_relocate = 0;
        scan_extern0(i, tbl);
        scan_extern1(i, tbl);
    }

    Section * sect = get_section("text");
    if(sect && verbose) {
      char * code = sect->buffer;
      for(i = 0; i < sect->size; i++) {
         cout << (int)code[i] << ", ";
         if(i % 4 == 0)
            cout << endl;
      }
      cout << endl;
    }
}

const char *
ObjectCode::get_symbol_name(const unsigned short t)
{
  const char * ret = "UNKNOWN";
  switch(t) {
      case DT_NON:
      ret = "NON";
      break;
     case DT_PTR:
      ret = "PTR";
      break;
      case DT_FCN:
      ret = "FCN";
      break;
      case DT_ARY:
      ret = "ARY";
      break;
      default:
      ret = "UNKNOWN";
  }
  return ret;
}

const char * 
ObjectCode::get_storage_class(const unsigned short t)
{
   const char * ret = "";
   switch(t) {
      case C_EFCN:
      ret = "EFCN";
      break;
      case C_NULL:
      ret = "NULL";
      break;
      case C_AUTO:
      ret = "AUTO";
      break;
      case C_EXT:
      ret = "EXT";
      break;
      case C_STAT:
      ret = "STAT";
      break;
      case C_REG:
      ret = "REG";
      break;
      case C_EXTDEF:
      ret = "EXTDEF";
      break;
      case C_LABEL:
      ret = "LABEL";
      break;
      case C_ULABEL:
      ret = "ULABEL";
      break;
      case C_MOS:
      ret = "MOS";
      break;
      case C_ARG:
      ret = "ARG";
      break;
      case C_STRTAG:
      ret = "STRING";
      break;
      case C_MOU:
      ret = "MOU";
      break;
      case C_UNTAG:
      ret = "UNTAG";
      break;
      case C_TPDEF:
      ret = "TPDEF";
      break;
      case C_USTATIC:
      ret = "USTATIC";
      break;
      case C_ENTAG:
      ret = "ENTAG";
      break;
      case C_MOE: 
      ret = "MOE";
      break;
      case C_REGPARM:
      ret = "REGPARM";
      break;
      case C_FIELD:
      ret = "FIELD";
      break;
      case C_AUTOARG:
      ret = "AUTOARG";
      break;
      case C_LASTENT:
      ret = "LASTENT";
      break;
      case C_BLOCK:
      ret = "BLOCK";
      break;
      case C_FCN:
      ret = "FCN";
      break;
      case C_EOS:
      ret = "EOS";
      break;
      case C_FILE:
      ret = "FILE";
      break;
      case C_LINE:
      ret = "LINE";
      break;
      case C_ALIAS:
      ret = "ALIAS";
      break;
      case C_HIDDEN:
      ret = "HIDDEN";
      break;
      default:
      ret = "UNKNWN";
      break;
   }
   return ret;
}

const char * ObjectCode::get_type(unsigned int code)
{
  const char * ret = "UNKNOWN";
  switch(code) {
      case T_NULL:
      ret = "NULL";
      break;
      case T_VOID:
      ret = "VOID";
      break;
      case T_CHAR:
      ret = "CHAR";
      break;
      case T_SHORT:
      ret = "SHORT";
      break;
      case T_INT:
      ret = "INT";
      break;
      case T_LONG:
      ret = "LONG";
      break;
      case T_FLOAT:
      ret = "FLOAT";
      break;
      case T_DOUBLE:
      ret = "DOUBLE";
      break;
      case T_STRUCT:
      ret = "STRUCT";
      break;
      case T_UNION:
      ret = "UNION";
      break;
      case T_ENUM:
      ret = "ENUM";
      break;
      case T_MOE:
      ret = "MOE";
      break;
      case T_UCHAR:
      ret = "UCHAR";
      break;
      case T_USHORT:
      ret = "USHORT";
      break;
      case T_LNGDBL:
      ret = "LNGDBL";
      break;
      case T_UINT:
      ret = "UINT";
      break;
      case T_ULONG:
      ret = "ULONG";
      break;
  }
  return ret;
}

void
ObjectCode::read_file_header()
{
   FILHDR buf;
   read((char*)&buf,FILHSZ);

   if(I386BADMAG(buf)) {
      throw "Error: no coff File\n";
   }

   nrSect = buf.f_nscns;
   flags = buf.f_flags;
   symptr = buf.f_symptr;
   nsyms = buf.f_nsyms;

   if(verbose) {
      cout << "\n\nFile Header:\n";
      cout << "***********************************************\n";
      cout << "Number of Sections:          " << nrSect << endl;
      cout << "Timestamp:                   " << ctime((time_t*)&buf.f_timdat) << endl;
      cout << "Number of Symtab entries:    " << buf.f_nsyms << endl;
      cout << "Size of optional Header:     " << buf.f_opthdr << endl;

      cout << "\nFlags:\n";
      cout << "-Relocations in File:        " << YESNO(flags&F_RELFLG) << endl;
      cout << "-Executeble File:            " << YESNO(flags&F_EXEC) << endl;
      cout << "-No Line Number Information: " << YESNO(flags&F_LNNO) << endl;
      cout << "-Local Symbols removed:      " << YESNO(flags&F_LSYMS) << endl;
      cout << "-32 Bit Little Endian File:  " << YESNO(flags&0x0100) << endl;
   }
   read_aout(&buf);

   section_seek = FILHSZ + buf.f_opthdr;
}

void
ObjectCode::read_strings()
{
   int strings;

   strings = symptr+sizeof(SYMENT)*nsyms;

   coffFile.seekg(strings, ios::beg);

   read((char*)&str_length,sizeof(long));

   if(str_length) { 
      str_length -= 4;

      sym_tbl = new char [str_length];

      memset(sym_tbl, 0, str_length);

      coffFile.seekg(strings+4, ios::beg);

      read(sym_tbl, str_length);

      char * str_ptr = sym_tbl;
      do {
         if(verbose) {
            cout << str_ptr << endl;
         }
         while(*str_ptr++ != '\0') {
            ;
         }
      }
      while(str_ptr < (sym_tbl+str_length));
   }
}

void
ObjectCode::read_symbols()
{
  SYMENT sym;
  AUXENT aux;
  int i,j,k;
  int count = 1;
  int offset = 0;

  coffFile.seekg(symptr, ios::beg);
  Section * sect = get_section("data");
  Section * bss_sect = get_section("bss");
  if(sect) {
      char * data = sect->buffer;
      char * bss = 0;
      if(bss_sect) {
         bss = bss_sect->buffer;
      }
      char * temp = data;
      Symbol * p_symbol = 0;
      for(j = 0; j < nsyms;) {
         memset(&sym,0,sizeof(sym));
         read((char*)&sym,sizeof(sym)-2);
         long off  = coffFile.tellg();
         p_symbol = new Symbol();
         p_symbol->name = sym.e_name;

         if(sym.e_scnum == 1) {
            if(bss)
            p_symbol->pointer = bss + sym.e_value;
         }
         else if(sym.e_scnum == 3) {
            if(data)
            p_symbol->pointer = data + sym.e_value;
         }
         else {
            if(data)
            p_symbol->pointer = data;
         }
         
         p_symbol->address = sym.e_value;
         p_symbol->sect = section_vec[sym.e_scnum-1];

         if(sym.e_sclass == 2) {
            char * ptr = get_dll_symbol(p_symbol->name);
            if(ptr != 0) {
               p_symbol->pointer = ptr;
               p_symbol->is_ext = true;
            }
            else if(sym.e_scnum == 0) {
               p_symbol->pointer = 0;
               p_symbol->is_ext = true;
            }
         }

         symbol_vec.push_back(p_symbol);

         j++;

         if(sym.e_numaux > 0) {
            for(k = 0; k < sym.e_numaux; k++) {
               memset(&aux,0,sizeof(aux));
               read((char*)&aux,sizeof(aux)-2);
               j++;
               p_symbol = new Symbol();
               symbol_vec.push_back(p_symbol);
            }
         }
      }
      data = temp;
  }
}

char * ObjectCode::get_dll_symbol(const string & name)
{
   char* ptr = 0;
   string temp = name;
   if(name.size()) if(name[0] == '_')
      temp = temp.substr(1);
   for(size_t i = 0; i < linker->dll_vec.size(); i++) {
      if((ptr=(char*)GetProcAddress((HINSTANCE)linker->dll_vec[i], temp.c_str())) != 0) {
         break;
      }
   }
   return ptr;
}

void ObjectCode::read_aout(FILHDR * buf)
{
   int rc;
   GNU_AOUT gnu_aout;
   AOUTHDR aout;
   if(buf->f_opthdr>0) {
      if(buf->f_opthdr==sizeof(GNU_AOUT)) {
         read((char*)&gnu_aout,sizeof(GNU_AOUT));
         cerr << "\nOptional GNU-aout Header:\n"
               << "-Entry Point: "
               << ((GNU_AOUT*)buf)->entry << "\n";
      }
      else if(buf->f_opthdr==AOUTSZ) {
         read((char*)&aout,AOUTSZ);
         cerr << "\nOptional aout Header:\n"
               << "-Entry Point: " << aout.entry << "\n";
      }
      else {
         cerr << "\nUnknown optional Header..\n";
      }
   }
}

void ObjectCode::read_header(SCNHDR * buf)
{
   int rc;
   read((char*)buf,SCNHSZ);
   flags=buf->s_flags;

   if(verbose) {
      cout << "\n\nSection: " << buf->s_name << endl;
      cout << "***********************************************\n";
      cout << "Physical Adress:                 " << buf->s_paddr << "\n";
      cout << "Virtual Adress:                  " << buf->s_vaddr << "\n";
      cout << "Section Size:                    " << buf->s_size << "\n";
      cout << "Relocation entries:              " << buf->s_nreloc << "\n";
      cout << "Line number entries:             " << buf->s_nlnno << "\n";
      cout << "Relocation Data Address:         " << buf->s_relptr << "\n";
   }

   if(buf->s_relptr) {
      coffFile.seekg(buf->s_relptr - buf->s_size, ios::beg);
   }

   if(verbose) {
      cout << "\nFlags:\n";
      cout << "-contains only executable code:  " << YESNO(flags&STYP_TEXT) << endl;
      cout << "-contains only initialized data: " << YESNO(flags&STYP_DATA) << endl;
      cout << "-defines uninitialized data,\n";
      cout << " and has no data stored in the\n";
      cout << " coff file for it:" << YESNO(flags&STYP_BSS) << endl
         << endl;

      if(flags&STYP_TEXT) {
         cout << "CODE*********\n";
      }
      if(flags&STYP_DATA) {
         cout << "DATA*********\n";
      }
      if(flags&STYP_BSS) {
         cout << "BSS**********\n";
      }
   }
}

void ObjectCode::read_bss(SCNHDR * buf)
{
   if(flags&STYP_BSS && buf->s_size != 0) {
      char * buffer = new char[buf->s_size];
      memset(buffer, 0, buf->s_size);
      read(buffer,buf->s_size);

      if(verbose) {
         cout << "\n\nBSS Section: " << buf->s_name << endl;
         cout << "***********************************************\n";
         cout << "Physical Adress:                 " << buf->s_paddr << "\n";
         cout << "Virtual Adress:                  " << buf->s_vaddr << "\n";
         cout << "Section Size:                    " << buf->s_size << "\n";
         cout << "Relocation entries:              " << buf->s_nreloc << "\n";
         cout << "Line number entries:             " << buf->s_nlnno << "\n";
         cout << "Relocation Data Address:         " << buf->s_relptr << "\n";
      }

      p_section->name = "bss";
      p_section->buffer = buffer;
      p_section->size = buf->s_size;
   }
}

void ObjectCode::read_data(SCNHDR * buf)
{
   int j;
   if(flags&STYP_DATA && buf->s_size != 0) {
      char * buffer = new char[buf->s_size];
      memset(buffer, 0, buf->s_size);
      read(buffer,buf->s_size);
      if(verbose) {
         for(j = 0; j < buf->s_size; j++) {
            if(buffer[j] != '\0') {
               cout << buffer[j];
            }
         }  
      }
      p_section->name = "data";
      p_section->buffer = buffer;
      p_section->size = buf->s_size;
   }
}

void ObjectCode::read_text(SCNHDR * buf)
{
   int j;
   //RELOC * relocation;
   if(flags&STYP_TEXT && buf->s_size != 0) {
      char * buffer = new char[buf->s_size];
      p_section->name = "text";
      p_section->buffer = buffer;
      p_section->size = buf->s_size;
      memset(buffer, 0, buf->s_size);
      read(buffer,buf->s_size);
      if(verbose) {
         for(j = 1; j <= buf->s_size; j++) {
            cout << (int)buffer[j-1] << ",";
            if((j % 5) == 0) {
               cout << "\n";
            }
         }  
         cout << "\n";
      }
       
      coffFile.seekg(buf->s_relptr, ios::beg);
      RELOC relocation;
      for(j = 0; j < buf->s_nreloc; j++) {
         read((char*)&relocation, sizeof(RELOC));
         if(verbose) {
            cout << "Relocation address: " << relocation.r_vaddr << endl;
            cout << "Symbol index: " << relocation.r_symndx << endl;
            cout << "Symbol type: " << get_storage_class(relocation.r_type) << endl;
         }
         Reloc * p_reloc = new Reloc(); 
         p_reloc->address = relocation.r_vaddr;
         p_reloc->index = relocation.r_symndx; 
         p_section->add_relocation(p_reloc);
      }
   }
}

void ObjectCode::run() {
   pf_t pf = (pf_t)entry_ptr;
   cout << "pf next..." << endl;
   int rc = pf();
   cout << "result=" << rc << endl;
}

void ObjectCode::read_lineno(SCNHDR * section)
{
   if(section->s_nlnno && verbose) {
      cout << "**************LINE NO*****************" << endl;
   }
}

void ObjectCode::read_sections() 
{
   int currSect;
   SCNHDR section;

   for(currSect = 0; currSect < nrSect; currSect++) {
      coffFile.seekg(section_seek, ios::beg);

      read_header(&section);

      section_seek += sizeof(SCNHDR);

      p_section = new Section();

      section_vec.push_back(p_section);

      read_bss(&section);

      read_data(&section);

      read_text(&section);

      read_lineno(&section);

      p_section = 0;
   }
}

void ObjectCode::load()
{
   coffFile.open(file_name.c_str(), ios::in|ios::binary);

   if(coffFile.fail()) {
      throw "unable to open COFF file for reading...";
   }

   read_file_header();

   read_sections();

   read_strings();

   read_symbols();

   coffFile.close();
}

Symbol * Linker::get_symbol3(const string & sym)
{
   ObjectCode * obj_ptr = 0;
   Symbol * sym_ptr = 0, * ret = 0;
   for(size_t i = 0; i < obj_vec.size(); i++) {
      obj_ptr = obj_vec[i];
      for(size_t j = 0; j < obj_ptr->symbol_vec.size(); j++) {
         sym_ptr = obj_ptr->symbol_vec[j];
         if(strcmp(sym.c_str(), sym_ptr->name.c_str()) == 0 && sym_ptr->is_ext == false) {
            ret = sym_ptr;
            break;
         }
      }
      if(ret) {
         break;
      }
   }
   return ret;
}

ObjectCode * Linker::get_symbol(const string & name)
{
   ObjectCode * obj_ptr = 0;
   ObjectCode * obj = 0;
   Symbol * sym = 0; 
   for(size_t i = 0; i < obj_vec.size(); i++) {
      obj = obj_vec[i];
      for(size_t j = 0; j < obj->symbol_vec.size(); j++) {
         sym = obj_vec[i]->symbol_vec[j];
         if(strcmp(sym->name.c_str(), name.c_str()) == 0 && sym->is_ext == false) {
            obj_ptr = obj;
            break;
         }
      }
      if(obj_ptr != 0) {
         break;
      }
   }
   return obj_ptr;
}


int Linker::run(int argc, char ** argv) {
   ObjectCode * obj_ptr = 0;
   size_t i;
   HANDLE hDLL;
   for(i = 1; i < argc; i++) {
      if(strcmp(argv[i], "-verbose") == 0) {
         verbose = true;
         continue;    
      }
      if(ends_with(argv[i], ".dll")) {
         hDLL = LoadLibrary(argv[i]);
         dll_vec.push_back(hDLL);
      }
      else if(ends_with(argv[i], ".obj")) {
         obj_ptr = new ObjectCode(argv[i], this);

         obj_vec.push_back(obj_ptr);
      }
      else {
         throw "bad linker file...";
      }
   }

   for(i = 0; i < obj_vec.size(); i++) {
      obj_vec[i]->verbose = verbose;
      obj_vec[i]->load();
   }

   for(i = 0; i < obj_vec.size(); i++) {
      obj_vec[i]->link();
   }

   for(i = 0; i < obj_vec.size(); i++) {
      obj_vec[i]->link2();
   }

   ObjectCode * entry_ptr = 0;

   entry_ptr = get_symbol("_main");

   if(entry_ptr == 0) {
      throw "no main entry point...";
   }

   entry_ptr->entry_ptr = entry_ptr->get_symbol("_main");

   entry_ptr->run();

   return 0;
}

int main(int argc, char** argv)
{
  int rc = 0;

  if(argc < 2) {
     usage();
  }

  try {
     Linker linker;
     rc = linker.run(argc,argv);
  }
  catch(const char * message) {
     cerr << message << endl;
     rc = 1;
  }
  catch(...) {
     cerr << "exception..." << endl;
     rc = 1;   
  }

  exit(rc);

  return rc;
}

void usage()
{
  cout << "Usage: runcoff [-verbose] <coff-file>\n";
  exit(0);
}
