%{
/**
 *
 * Test parser for the qP+ grammer.
 *
 * Author: Matthew W. Coan
 * Sun Feb  9 15:29:34 EST 2003
 */

#include <cstdio>
#include <string>
#include <vector>
#include <map>
#include <iostream>

using namespace std;

typedef vector< string > string_vector_type;
typedef map< string, string > string_map_type;

string_map_type type_map;

string_vector_type * id_vector = 0;

extern int yylex();
extern int yyerror(const char * msg);
const char * op = NULL;
int label = 0;
int my_count = 0;
string the_type;
string end_label;
string start_label;

bool is_global(const char * str) {
   bool ret = false;
   return ret;
}

string get_next_label() {
   string ret;

   char buffer[100];

   memset(buffer, 0, 100);

   sprintf(buffer, ".L%d", label);

   label++;

   ret = buffer;

   return ret;
}

typedef vector< string > const_vector_type;

const_vector_type const_vec;

class instruction {
public:
   string op;
   string arg1;
   string arg2;
   string label;

   instruction() { 

   }

   instruction(const instruction & c) {
      op = c.op;
      arg1 = c.arg1;
      arg2 = c.arg2;
      label = c.label;
   }

   ~instruction() {

   }

   instruction & operator=(const instruction & inst) {
      op = inst.op;
      arg1 = inst.arg1;
      arg2 = inst.arg2;
      label = inst.label;
      return *this;
   }
};

typedef vector< instruction > instruction_vector_type;

instruction_vector_type code;

void
add_instruction(const string & label)
{
   instruction inst;
   inst.label = label;
   code.push_back(inst);
}

void
add_instruction(const string & op,
     const string & arg1)
{
   instruction inst;
   inst.op = op;
   inst.arg1 = arg1;
   code.push_back(inst);
}

void
add_instruction(const string & op,
     const string & arg1, 
     const string & arg2)
{
   instruction inst;
   inst.op = op;
   inst.arg1 = arg1;
   inst.arg2 = arg2;
   code.push_back(inst);
}
     
void
emit()
{
   cout << "extern read_int" << endl << endl << flush;
   cout << "extern write_int" << endl << endl << flush;
   cout << "extern write_string" << endl << endl << flush;
   cout << "global main" << endl << endl << flush;
   for(size_t i = 0; i < code.size(); i++) {
      if(code[i].arg1 != "" && code[i].arg2 != "") {
         cout << '\t' << code[i].op << " " << code[i].arg1 << "," << code[i].arg2 << endl << flush;
      }
      else if(code[i].arg1 != "" && code[i].op != "") {
         if(code[i].op == "jz" || code[i].op == "je" || code[i].op == "jmp")
            cout << '\t' << code[i].op << " " << code[i].arg1 << endl << flush;
         else 
            cout << '\t' << code[i].op << " dword " << code[i].arg1 << endl << flush;
      }
      else if(code[i].arg1 == "" && code[i].arg2 == "" && code[i].op != "") {
         cout << '\t' << code[i].op << endl << flush;
      }
      else if(code[i].label != "") {
         if(code[i].label[0] == '.')
            cout << code[i].label << ":" << endl << flush;
         else 
            cout << code[i].label << endl << flush;
      }
   }
}

%}

%union {
   const char * sval;
}


%token QP_MAIN
%token QP_DO
%token QP_VAR
%token QP_NEW
%token QP_READ
%token QP_WRITE
%token QP_IF
%token QP_WHILE
%token QP_STRING_NAME
%token QP_CHAR_NAME
%token QP_INT_NAME
%token QP_BOOLEAN_NAME
%token QP_TRUE
%token QP_FALSE
%token QP_NOT
%token QP_GTEQ
%token QP_LTEQ
%token QP_EQ
%token QP_NEQ
%token <sval> QP_NAME
%token <sval> QP_STRING
%token <sval> QP_CHAR
%token <sval> QP_INT
%token <sval> QP_BOOLEAN
%left '-' '+'
%left '*' '/'

%type <sval> expression
%type <sval> lefthandside
%type <sval> righthandside
%type <sval> simple_expression
%type <sval> term
%type <sval> factor

%%

start: QP_MAIN QP_NAME '(' identifier_list ')' ';'  
       {
       }
       declarations 
       {
          char str[100];
          add_instruction("%include \"macro.asm\"");
          add_instruction("main:");
          add_instruction("push", "ebp");
          add_instruction("mov", "ebp", "esp");
          sprintf(str, "%d", my_count);
          add_instruction("sub", "esp", str); 
       }
       compound_statement 
       '$'
       {
         add_instruction("mov", "eax", "0"); 
         char str[100];
         sprintf(str, "%d", my_count);
         add_instruction("add", "esp", str); 
         add_instruction("mov", "esp", "ebp");
         add_instruction("pop", "ebp");
         add_instruction("ret", ""); 

         char buffer[1024];
         for(size_t i = 0; i < const_vec.size(); i++) {
            sprintf(buffer, "C%d: db %s,0", i, const_vec[i].c_str());
            add_instruction(buffer); 
         }

         const_vec.clear();

         emit();
      }
   ;

identifier_list: QP_NAME  { id_vector->push_back(string($1)); }
   | identifier_list ',' QP_NAME { id_vector->push_back(string($3)); }
   ;

declarations: declarations QP_VAR identifier_list ':' type ';' 
   {
      char buffer[1024];
      for(size_t i = 0; i < id_vector->size(); i++) {
         my_count += 4;

         type_map[(*id_vector)[i]] = the_type;

         sprintf(buffer, "%s equ %d", (*id_vector)[i].c_str(), my_count);
         add_instruction(buffer);
      }

      id_vector->clear();
   }
   | 
   { }
   ;

type: standard_type | QP_STRING_NAME { the_type = "string"; }
   ;

standard_type: QP_CHAR_NAME { the_type = "char"; } 
               | QP_INT_NAME { the_type = "int"; }
               | QP_BOOLEAN_NAME { the_type = "boolean"; }
   { }
   ;

compound_statement: '{' optional_statements '}'
   { 
   } 
   ;

optional_statements: statement_list | object ';' optional_statements |
   { }
   ;

object: QP_NAME '=' QP_NEW QP_STRING_NAME '[' size ']'
   { }
   ;

statement_list: statement 
      | statement_list ';' statement
   { }
   ;

statement: lefthandside
      | compound_statement
      | QP_READ '(' QP_NAME ')' {
         add_instruction("lea", "eax", "[ebp-" + string($3) + "]");
         add_instruction("push", "eax");
         add_instruction("call", "read_int");
         add_instruction("add", "esp", "4");
      }
      | QP_WRITE '(' QP_NAME ')' {
         add_instruction("push", "[ebp-" + string($3) + "]");

         if(type_map[$3] == "int")
            add_instruction("call", "write_int");
         else if(type_map[$3] == "string")
            add_instruction("call", "write_string");

         add_instruction("add", "esp", "4");
      }
      | QP_IF '(' expression ')' { 
         end_label = (get_next_label()); 
         add_instruction("pop", "eax");
         add_instruction("cmp", "eax", "0");
         add_instruction("je", end_label); } 
      statement { 
         add_instruction(end_label);
      }
      | QP_WHILE '(' 
      {
         start_label = (get_next_label()); 
         add_instruction(start_label);
      }
      expression ')' QP_DO 
      {
         end_label = (get_next_label()); 
         add_instruction("pop", "eax");
         add_instruction("cmp", "eax", "0");
         add_instruction("je", end_label); 
      }
      statement
      {
         add_instruction("jmp", start_label);
         add_instruction(end_label);
      }
   { }
   ;

lefthandside: QP_NAME '=' righthandside
   { 
      char buffer[1024];
      sprintf(buffer, "[ebp-%s]", $1);
      add_instruction("pop", buffer); }
   ;

righthandside: expression 
      | QP_STRING { 
           string temp = $1;
           int val = const_vec.size();
           const_vec.push_back(temp);
           char buffer[1024];
           sprintf(buffer, "C%d", val);
           add_instruction("push", buffer); 
        }
      | casting expression
   { }
   ;

casting: standard_type simple_expression
   { }
   ;

expression: simple_expression
      | simple_expression relop simple_expression { add_instruction(op, ""); }
   { }
   ;

simple_expression: term
      | simple_expression addop term  { add_instruction(op, ""); }
   { }
   ;

term: factor
      | term mulop factor { add_instruction(op, ""); }
   { }
   ;

factor: QP_NAME 
      { 
         if(is_global($1)) {
            add_instruction("push", "[" + string($1) + "]"); 
         }
         else {
            
            add_instruction("push", "[ebp-" + string($1) + "]"); 
         }
      }
      | QP_INT { 
         add_instruction("push", $1); }
      | QP_TRUE { add_instruction("push", "1"); }
      | QP_FALSE { add_instruction("push", "0"); }
      | QP_NOT factor { add_instruction("not"); }
   { }
   ;

size: QP_INT
   { }
   ;

relop: '>' { op = "int_gt"; }
      | QP_GTEQ { op = "int_gteq"; }
      | QP_EQ { op = "int_eq"; }
      | QP_LTEQ { op = "int_lteq"; }
      | '<' { op = "int_lt"; }
      | QP_NEQ { op = "int_neq"; }
   { }
   ;

addop: '+' { op = "int_add"; } 
      | '-' { op = "int_sub"; }
   { }
   ;

mulop: '*'  { op = "int_mul"; }
      | '/' { op = "int_div"; }
      | '%' { op = "int_mod"; }
   { }
   ;

%%
