#include <stdlib.h>
#include <string.h>
#ifndef lint
#ifdef __unused
__unused
#endif
static char const 
yyrcsid[] = "$FreeBSD: src/usr.bin/yacc/skeleton.c,v 1.39.2.2.2.1 2010/12/21 17:09:25 kensmith Exp $";
#endif
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYLEX yylex()
#define YYEMPTY -1
#define yyclearin (yychar=(YYEMPTY))
#define yyerrok (yyerrflag=0)
#define YYRECOVERING() (yyerrflag!=0)
#if defined(__cplusplus) || __STDC__
static int yygrowstack(void);
#else
static int yygrowstack();
#endif
#define YYPREFIX "yy"
#line 2 "qp.y"
/**
 *
 * Test parser for the qP+ grammer.
 *
 * Author: Matthew W. Coan
 * Sun Feb  9 15:29:34 EST 2003
 */

#include <cstdio>
#include <string>
#include <vector>
#include <map>
#include <iostream>

using namespace std;

typedef vector< string > string_vector_type;
typedef map< string, string > string_map_type;

string_map_type type_map;

string_vector_type * id_vector = 0;

extern int yylex();
extern int yyerror(const char * msg);
const char * op = NULL;
int label = 0;
int my_count = 0;
string the_type;
string end_label;
string start_label;

bool is_global(const char * str) {
   bool ret = false;
   return ret;
}

string get_next_label() {
   string ret;

   char buffer[100];

   memset(buffer, 0, 100);

   sprintf(buffer, ".L%d", label);

   label++;

   ret = buffer;

   return ret;
}

typedef vector< string > const_vector_type;

const_vector_type const_vec;

class instruction {
public:
   string op;
   string arg1;
   string arg2;
   string label;

   instruction() { 

   }

   instruction(const instruction & c) {
      op = c.op;
      arg1 = c.arg1;
      arg2 = c.arg2;
      label = c.label;
   }

   ~instruction() {

   }

   instruction & operator=(const instruction & inst) {
      op = inst.op;
      arg1 = inst.arg1;
      arg2 = inst.arg2;
      label = inst.label;
      return *this;
   }
};

typedef vector< instruction > instruction_vector_type;

instruction_vector_type code;

void
add_instruction(const string & label)
{
   instruction inst;
   inst.label = label;
   code.push_back(inst);
}

void
add_instruction(const string & op,
     const string & arg1)
{
   instruction inst;
   inst.op = op;
   inst.arg1 = arg1;
   code.push_back(inst);
}

void
add_instruction(const string & op,
     const string & arg1, 
     const string & arg2)
{
   instruction inst;
   inst.op = op;
   inst.arg1 = arg1;
   inst.arg2 = arg2;
   code.push_back(inst);
}
     
void
emit()
{
   cout << "extern read_int" << endl << endl << flush;
   cout << "extern write_int" << endl << endl << flush;
   cout << "extern write_string" << endl << endl << flush;
   cout << "global main" << endl << endl << flush;
   for(size_t i = 0; i < code.size(); i++) {
      if(code[i].arg1 != "" && code[i].arg2 != "") {
         cout << '\t' << code[i].op << " " << code[i].arg1 << "," << code[i].arg2 << endl << flush;
      }
      else if(code[i].arg1 != "" && code[i].op != "") {
         if(code[i].op == "jz" || code[i].op == "je" || code[i].op == "jmp")
            cout << '\t' << code[i].op << " " << code[i].arg1 << endl << flush;
         else 
            cout << '\t' << code[i].op << " dword " << code[i].arg1 << endl << flush;
      }
      else if(code[i].arg1 == "" && code[i].arg2 == "" && code[i].op != "") {
         cout << '\t' << code[i].op << endl << flush;
      }
      else if(code[i].label != "") {
         if(code[i].label[0] == '.')
            cout << code[i].label << ":" << endl << flush;
         else 
            cout << code[i].label << endl << flush;
      }
   }
}

#line 155 "qp.y"
typedef union {
   const char * sval;
} YYSTYPE;
#line 181 "y.tab.c"
#define YYERRCODE 256
#define QP_MAIN 257
#define QP_DO 258
#define QP_VAR 259
#define QP_NEW 260
#define QP_READ 261
#define QP_WRITE 262
#define QP_IF 263
#define QP_WHILE 264
#define QP_STRING_NAME 265
#define QP_CHAR_NAME 266
#define QP_INT_NAME 267
#define QP_BOOLEAN_NAME 268
#define QP_TRUE 269
#define QP_FALSE 270
#define QP_NOT 271
#define QP_GTEQ 272
#define QP_LTEQ 273
#define QP_EQ 274
#define QP_NEQ 275
#define QP_NAME 276
#define QP_STRING 277
#define QP_CHAR 278
#define QP_INT 279
#define QP_BOOLEAN 280
const short yylhs[] = {                                        -1,
    9,   11,    0,    7,    7,    8,    8,   12,   12,   13,
   13,   14,   13,   10,   15,   15,   15,   17,   16,   16,
   19,   19,   19,   19,   20,   19,   21,   22,   23,   19,
    2,    3,    3,    3,   24,    1,   26,    1,    4,   28,
    4,    5,   30,    5,    6,    6,    6,    6,   31,    6,
   18,   25,   25,   25,   25,   25,   32,   25,   27,   33,
   27,   29,   29,   34,   29,
};
const short yylen[] = {                                         2,
    0,    0,   11,    1,    3,    6,    0,    1,    1,    1,
    1,    0,    2,    3,    1,    3,    0,    7,    1,    3,
    1,    1,    4,    4,    0,    6,    0,    0,    0,    9,
    3,    1,    1,    2,    2,    1,    0,    4,    1,    0,
    4,    1,    0,    4,    1,    1,    1,    1,    0,    3,
    1,    1,    1,    1,    1,    1,    0,    2,    1,    0,
    2,    1,    1,    0,    2,
};
const short yydefred[] = {                                      0,
    0,    0,    0,    0,    4,    0,    0,    0,    1,    5,
    7,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   21,   22,    0,    0,    0,   19,    3,
    9,   10,   11,   12,    0,    8,    0,    0,    0,   27,
    0,   14,    0,    0,   13,    6,    0,    0,   47,   48,
    0,   45,   46,    0,    0,    0,   42,    0,    0,   33,
   32,   31,    0,    0,    0,   20,   16,   23,   24,   49,
   25,   53,   55,   54,   57,   60,   59,   52,   56,    0,
    0,   62,   63,   64,    0,    0,    0,    0,   34,    0,
   50,    0,   58,   61,    0,    0,   65,   43,    0,    0,
   26,   38,   41,   44,   28,   51,    0,    0,   18,   29,
   30,
};
const short yydgoto[] = {                                       2,
   61,   24,   62,   55,   56,   57,    6,   12,   11,   25,
   14,   35,   63,   45,   26,   27,   28,  107,   29,   92,
   58,  108,  111,   64,   80,  102,   81,  103,   85,  104,
   91,   93,   94,   97,
};
const short yysindex[] = {                                   -229,
 -234,    0,    3, -226,    0,  -24,   -8, -223,    0,    0,
    0, -203, -226,  -65,  -35, -122,   31, -232,   25,   37,
   38,   39,   20,    0,    0,  -43,   26,   30,    0,    0,
    0,    0,    0,    0,   35,    0, -186, -179, -196,    0,
 -222,    0, -118, -122,    0,    0,   57,   58,    0,    0,
 -196,    0,    0,   59,  -21,   29,    0, -196, -164,    0,
    0,    0, -196, -196,   41,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -196,
 -196,    0,    0,    0, -196,   62,   13,  -29,    0, -207,
    0, -118,    0,    0,  -29,   29,    0,    0, -153, -173,
    0,    0,    0,    0,    0,    0,   14, -118,    0,    0,
    0,
};
const short yyrindex[] = {                                      0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  -15,    0,    0,    0,  -16,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  -14,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  -16,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  -34,  -41,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, -183,    0,    0,
    0,    0,    0,    0,  -33,  -30,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,
};
const short yygindex[] = {                                      0,
  -27,    0,    0,  -53,   32,  -45,   97,    0,    0,   98,
    0,    0,   96,    0,   71,    0,    0,    0,  -40,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,
};
#define YYTABLESIZE 254
const short yytable[] = {                                      39,
   16,   39,   66,   39,   16,   70,   36,   37,    8,   88,
   40,   54,   40,   77,   40,   76,    7,   39,   39,    8,
   39,   77,   18,   76,   36,   37,   95,    1,   40,   40,
   86,   40,   31,   32,   33,   34,   89,   59,   79,   98,
   78,    3,    4,   32,   33,   34,   49,   50,   51,    5,
    9,  101,   10,   52,   60,   13,   53,   16,   32,   33,
   34,   49,   50,   51,   37,   84,   30,  110,   52,   60,
   82,   53,   49,   50,   51,   83,   38,   39,   40,   52,
   41,   42,   53,   39,   43,   35,   35,   35,   44,   47,
   36,   37,   35,   46,   40,   35,   48,   68,   69,   71,
   87,   90,   99,  100,  105,  106,  109,    2,   17,   15,
   15,   17,   96,   36,   67,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   19,   20,
   21,   22,   19,   20,   21,   22,    0,    0,    0,    0,
    0,    0,    0,   23,    0,    0,    0,   65,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   39,   39,   39,
   39,   39,   39,   39,   39,    0,    0,   39,   40,   40,
   40,   40,   40,   40,   40,   40,    0,    0,   40,    0,
   72,   73,   74,   75,
};
const short yycheck[] = {                                      41,
  123,   43,   43,   45,  123,   51,   41,   41,   44,   63,
   41,   39,   43,   43,   45,   45,   41,   59,   60,   44,
   62,   43,   58,   45,   59,   59,   80,  257,   59,   60,
   58,   62,  265,  266,  267,  268,   64,  260,   60,   85,
   62,  276,   40,  266,  267,  268,  269,  270,  271,  276,
   59,   92,  276,  276,  277,  259,  279,  123,  266,  267,
  268,  269,  270,  271,   40,   37,   36,  108,  276,  277,
   42,  279,  269,  270,  271,   47,   40,   40,   40,  276,
   61,  125,  279,  125,   59,  269,  270,  271,   59,  276,
  125,  125,  276,   59,  125,  279,  276,   41,   41,   41,
  265,   61,   41,   91,  258,  279,   93,  123,  125,   13,
  125,   14,   81,   18,   44,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  261,  262,
  263,  264,  261,  262,  263,  264,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  276,   -1,   -1,   -1,  276,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  269,  270,  271,
  272,  273,  274,  275,  276,   -1,   -1,  279,  269,  270,
  271,  272,  273,  274,  275,  276,   -1,   -1,  279,   -1,
  272,  273,  274,  275,
};
#define YYFINAL 2
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 280
#if YYDEBUG
const char * const yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,"'$'","'%'",0,0,"'('","')'","'*'","'+'","','","'-'",0,"'/'",0,0,0,0,0,0,0,0,
0,0,"':'","';'","'<'","'='","'>'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,"'['",0,"']'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,"'{'",0,"'}'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"QP_MAIN","QP_DO","QP_VAR","QP_NEW",
"QP_READ","QP_WRITE","QP_IF","QP_WHILE","QP_STRING_NAME","QP_CHAR_NAME",
"QP_INT_NAME","QP_BOOLEAN_NAME","QP_TRUE","QP_FALSE","QP_NOT","QP_GTEQ",
"QP_LTEQ","QP_EQ","QP_NEQ","QP_NAME","QP_STRING","QP_CHAR","QP_INT",
"QP_BOOLEAN",
};
const char * const yyrule[] = {
"$accept : start",
"$$1 :",
"$$2 :",
"start : QP_MAIN QP_NAME '(' identifier_list ')' ';' $$1 declarations $$2 compound_statement '$'",
"identifier_list : QP_NAME",
"identifier_list : identifier_list ',' QP_NAME",
"declarations : declarations QP_VAR identifier_list ':' type ';'",
"declarations :",
"type : standard_type",
"type : QP_STRING_NAME",
"standard_type : QP_CHAR_NAME",
"standard_type : QP_INT_NAME",
"$$3 :",
"standard_type : QP_BOOLEAN_NAME $$3",
"compound_statement : '{' optional_statements '}'",
"optional_statements : statement_list",
"optional_statements : object ';' optional_statements",
"optional_statements :",
"object : QP_NAME '=' QP_NEW QP_STRING_NAME '[' size ']'",
"statement_list : statement",
"statement_list : statement_list ';' statement",
"statement : lefthandside",
"statement : compound_statement",
"statement : QP_READ '(' QP_NAME ')'",
"statement : QP_WRITE '(' QP_NAME ')'",
"$$4 :",
"statement : QP_IF '(' expression ')' $$4 statement",
"$$5 :",
"$$6 :",
"$$7 :",
"statement : QP_WHILE '(' $$5 expression ')' QP_DO $$6 statement $$7",
"lefthandside : QP_NAME '=' righthandside",
"righthandside : expression",
"righthandside : QP_STRING",
"righthandside : casting expression",
"casting : standard_type simple_expression",
"expression : simple_expression",
"$$8 :",
"expression : simple_expression relop simple_expression $$8",
"simple_expression : term",
"$$9 :",
"simple_expression : simple_expression addop term $$9",
"term : factor",
"$$10 :",
"term : term mulop factor $$10",
"factor : QP_NAME",
"factor : QP_INT",
"factor : QP_TRUE",
"factor : QP_FALSE",
"$$11 :",
"factor : QP_NOT factor $$11",
"size : QP_INT",
"relop : '>'",
"relop : QP_GTEQ",
"relop : QP_EQ",
"relop : QP_LTEQ",
"relop : '<'",
"$$12 :",
"relop : QP_NEQ $$12",
"addop : '+'",
"$$13 :",
"addop : '-' $$13",
"mulop : '*'",
"mulop : '/'",
"$$14 :",
"mulop : '%' $$14",
};
#endif
#if YYDEBUG
#include <stdio.h>
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH 10000
#endif
#endif
#define YYINITSTACKSIZE 200
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short *yyss;
short *yysslim;
YYSTYPE *yyvs;
int yystacksize;
/* allocate initial stack or double stack size, up to YYMAXDEPTH */
#if defined(__cplusplus) || __STDC__
static int yygrowstack(void)
#else
static int yygrowstack()
#endif
{
    int newsize, i;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = yystacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;
    i = yyssp - yyss;
    newss = yyss ? (short *)realloc(yyss, newsize * sizeof *newss) :
      (short *)malloc(newsize * sizeof *newss);
    if (newss == NULL)
        return -1;
    yyss = newss;
    yyssp = newss + i;
    newvs = yyvs ? (YYSTYPE *)realloc(yyvs, newsize * sizeof *newvs) :
      (YYSTYPE *)malloc(newsize * sizeof *newvs);
    if (newvs == NULL)
        return -1;
    yyvs = newvs;
    yyvsp = newvs + i;
    yystacksize = newsize;
    yysslim = yyss + newsize - 1;
    return 0;
}

#define YYABORT goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab

#ifndef YYPARSE_PARAM
#if defined(__cplusplus) || __STDC__
#define YYPARSE_PARAM_ARG void
#define YYPARSE_PARAM_DECL
#else	/* ! ANSI-C/C++ */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif	/* ANSI-C/C++ */
#else	/* YYPARSE_PARAM */
#ifndef YYPARSE_PARAM_TYPE
#define YYPARSE_PARAM_TYPE void *
#endif
#if defined(__cplusplus) || __STDC__
#define YYPARSE_PARAM_ARG YYPARSE_PARAM_TYPE YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else	/* ! ANSI-C/C++ */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL YYPARSE_PARAM_TYPE YYPARSE_PARAM;
#endif	/* ANSI-C/C++ */
#endif	/* ! YYPARSE_PARAM */

int
yyparse (YYPARSE_PARAM_ARG)
    YYPARSE_PARAM_DECL
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    if (yyss == NULL && yygrowstack()) goto yyoverflow;
    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if ((yyn = yydefred[yystate])) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yyssp >= yysslim && yygrowstack())
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#if defined(lint) || defined(__GNUC__)
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#if defined(lint) || defined(__GNUC__)
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yysslim && yygrowstack())
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    if (yym)
        yyval = yyvsp[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);
    switch (yyn)
    {
case 1:
#line 197 "qp.y"
{
       }
break;
case 2:
#line 200 "qp.y"
{
          char str[100];
          add_instruction("%include \"macro.asm\"");
          add_instruction("main:");
          add_instruction("push", "ebp");
          add_instruction("mov", "ebp", "esp");
          sprintf(str, "%d", my_count);
          add_instruction("sub", "esp", str); 
       }
break;
case 3:
#line 211 "qp.y"
{
         add_instruction("mov", "eax", "0"); 
         char str[100];
         sprintf(str, "%d", my_count);
         add_instruction("add", "esp", str); 
         add_instruction("mov", "esp", "ebp");
         add_instruction("pop", "ebp");
         add_instruction("ret", ""); 

         char buffer[1024];
         for(size_t i = 0; i < const_vec.size(); i++) {
            sprintf(buffer, "C%d: db %s,0", i, const_vec[i].c_str());
            add_instruction(buffer); 
         }

         const_vec.clear();

         emit();
      }
break;
case 4:
#line 232 "qp.y"
{ id_vector->push_back(string(yyvsp[0].sval)); }
break;
case 5:
#line 233 "qp.y"
{ id_vector->push_back(string(yyvsp[0].sval)); }
break;
case 6:
#line 237 "qp.y"
{
      char buffer[1024];
      for(size_t i = 0; i < id_vector->size(); i++) {
         my_count += 4;

         type_map[(*id_vector)[i]] = the_type;

         sprintf(buffer, "%s equ %d", (*id_vector)[i].c_str(), my_count);
         add_instruction(buffer);
      }

      id_vector->clear();
   }
break;
case 7:
#line 251 "qp.y"
{ }
break;
case 9:
#line 254 "qp.y"
{ the_type = "string"; }
break;
case 10:
#line 257 "qp.y"
{ the_type = "char"; }
break;
case 11:
#line 258 "qp.y"
{ the_type = "int"; }
break;
case 12:
#line 259 "qp.y"
{ the_type = "boolean"; }
break;
case 13:
#line 260 "qp.y"
{ }
break;
case 14:
#line 264 "qp.y"
{ 
   }
break;
case 17:
#line 269 "qp.y"
{ }
break;
case 18:
#line 273 "qp.y"
{ }
break;
case 20:
#line 278 "qp.y"
{ }
break;
case 23:
#line 283 "qp.y"
{
         add_instruction("lea", "eax", "[ebp-" + string(yyvsp[-1].sval) + "]");
         add_instruction("push", "eax");
         add_instruction("call", "read_int");
         add_instruction("add", "esp", "4");
      }
break;
case 24:
#line 289 "qp.y"
{
         add_instruction("push", "[ebp-" + string(yyvsp[-1].sval) + "]");

         if(type_map[yyvsp[-1].sval] == "int")
            add_instruction("call", "write_int");
         else if(type_map[yyvsp[-1].sval] == "string")
            add_instruction("call", "write_string");

         add_instruction("add", "esp", "4");
      }
break;
case 25:
#line 299 "qp.y"
{ 
         end_label = (get_next_label()); 
         add_instruction("pop", "eax");
         add_instruction("cmp", "eax", "0");
         add_instruction("je", end_label); }
break;
case 26:
#line 304 "qp.y"
{ 
         add_instruction(end_label);
      }
break;
case 27:
#line 308 "qp.y"
{
         start_label = (get_next_label()); 
         add_instruction(start_label);
      }
break;
case 28:
#line 313 "qp.y"
{
         end_label = (get_next_label()); 
         add_instruction("pop", "eax");
         add_instruction("cmp", "eax", "0");
         add_instruction("je", end_label); 
      }
break;
case 29:
#line 320 "qp.y"
{
         add_instruction("jmp", start_label);
         add_instruction(end_label);
      }
break;
case 30:
#line 324 "qp.y"
{ }
break;
case 31:
#line 328 "qp.y"
{ 
      char buffer[1024];
      sprintf(buffer, "[ebp-%s]", yyvsp[-2].sval);
      add_instruction("pop", buffer); }
break;
case 33:
#line 335 "qp.y"
{ 
           string temp = yyvsp[0].sval;
           int val = const_vec.size();
           const_vec.push_back(temp);
           char buffer[1024];
           sprintf(buffer, "C%d", val);
           add_instruction("push", buffer); 
        }
break;
case 34:
#line 344 "qp.y"
{ }
break;
case 35:
#line 348 "qp.y"
{ }
break;
case 37:
#line 352 "qp.y"
{ add_instruction(op, ""); }
break;
case 38:
#line 353 "qp.y"
{ }
break;
case 40:
#line 357 "qp.y"
{ add_instruction(op, ""); }
break;
case 41:
#line 358 "qp.y"
{ }
break;
case 43:
#line 362 "qp.y"
{ add_instruction(op, ""); }
break;
case 44:
#line 363 "qp.y"
{ }
break;
case 45:
#line 367 "qp.y"
{ 
         if(is_global(yyvsp[0].sval)) {
            add_instruction("push", "[" + string(yyvsp[0].sval) + "]"); 
         }
         else {
            
            add_instruction("push", "[ebp-" + string(yyvsp[0].sval) + "]"); 
         }
      }
break;
case 46:
#line 376 "qp.y"
{ 
         add_instruction("push", yyvsp[0].sval); }
break;
case 47:
#line 378 "qp.y"
{ add_instruction("push", "1"); }
break;
case 48:
#line 379 "qp.y"
{ add_instruction("push", "0"); }
break;
case 49:
#line 380 "qp.y"
{ add_instruction("not"); }
break;
case 50:
#line 381 "qp.y"
{ }
break;
case 51:
#line 385 "qp.y"
{ }
break;
case 52:
#line 388 "qp.y"
{ op = "int_gt"; }
break;
case 53:
#line 389 "qp.y"
{ op = "int_gteq"; }
break;
case 54:
#line 390 "qp.y"
{ op = "int_eq"; }
break;
case 55:
#line 391 "qp.y"
{ op = "int_lteq"; }
break;
case 56:
#line 392 "qp.y"
{ op = "int_lt"; }
break;
case 57:
#line 393 "qp.y"
{ op = "int_neq"; }
break;
case 58:
#line 394 "qp.y"
{ }
break;
case 59:
#line 397 "qp.y"
{ op = "int_add"; }
break;
case 60:
#line 398 "qp.y"
{ op = "int_sub"; }
break;
case 61:
#line 399 "qp.y"
{ }
break;
case 62:
#line 402 "qp.y"
{ op = "int_mul"; }
break;
case 63:
#line 403 "qp.y"
{ op = "int_div"; }
break;
case 64:
#line 404 "qp.y"
{ op = "int_mod"; }
break;
case 65:
#line 405 "qp.y"
{ }
break;
#line 963 "y.tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yyssp, yystate);
#endif
    if (yyssp >= yysslim && yygrowstack())
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
