%{
/**
 *
 * Test lexer for the qP+ grammer.
 *
 * Author: Matthew W. Coan
 * Sun Feb  9 15:25:57 EST 2003
 */

#include "y.tab.h"
#include <string.h>
#include <vector>
#include <string>

using namespace std;

int yylineno = 1;

string prog_name;

%}

%%

([ \t]+) {
   ;
}

([\r\n]) {
   yylineno++;
}

([0-9]+) {
   yylval.sval = strdup(yytext);
   return QP_INT;
}

(([\'])([^\'])([\'])) {
   yylval.sval = strdup(yytext);
   return QP_CHAR;
}

(([\"])([^\"]*)([\"])) {
   yylval.sval = strdup(yytext);
   return QP_STRING;
}

"MAIN" {
   return QP_MAIN;
}

"VAR" {
   return QP_VAR;
}

"NEW" {
   return QP_NEW;
}

"READ" {
   return QP_READ;
}

"WRITE" {
   return QP_WRITE;
}

"IF" {
   return QP_IF;
}

"WHILE" {
   return QP_WHILE;
}

"DO" {
   return QP_DO;
}

"STRING" {
   return QP_STRING_NAME;
}

"CHAR" {
   return QP_CHAR_NAME;
}

"INT" {
   return QP_INT_NAME;
}

"BOOLEAN" {
   return QP_BOOLEAN_NAME;
}

"TRUE" {
   return QP_TRUE;
}

"FALSE" {
   return QP_FALSE;
}

"NOT" {
   return QP_NOT;
}

">=" {
   return QP_GTEQ;
}

"<=" {
   return QP_LTEQ;
}

"==" {
   return QP_EQ;
}

"<>" {
   return QP_NEQ;
}

(([a-zA-Z])([a-zA-Z0-9\_]*)) {
   yylval.sval = strdup(yytext);
   return QP_NAME;
}

"{" {
   return '{';
}

"}" {
   return '}';
}

"<" {
   return '<';
}

">" {
   return '>';
}

"+" { 
   return '+';
}

"-" {
   return '-';
}

"*" {
   return '*';
}

"%" {
   return '%';
}

"=" {
   return '=';
}

"," {
   return ',';
}

";" {
   return ';';
}

"$" {
   return '$';
}

([/][/](.*)) {
   ;
}

"/" {
   return '/';
}

"(" {
   return '(';
}

")" {
   return ')';
}

":" {
   return ':';
}

%%

extern int yyparse();
typedef vector< string > string_vector_type;
extern string_vector_type * id_vector;

string
get_class_name(const string & str)
{
   string ret;

   for(size_t i = 0; i < str.size(); i++) {
      if(str[i] == '.')
         break;
      ret += str[i];
   }

   return ret;
}

/**
 * Main entry point:
 */
int 
main(int argc, char ** argv)
{
   FILE * fin;

   if(argc != 3) {
      fprintf(stderr, "Usage: %s <input file> <output file>\n", argv[0]);
      return -1;
   }

   fin = fopen(argv[1], "r");

   if(fin == NULL) {
      fprintf(stderr, "Unable to open file for reading: %s\n", argv[1]);
      return -1;
   }

   prog_name = argv[2];

   yyin = fin;

   id_vector = new string_vector_type();

   yyparse();

   delete id_vector;

   fclose(fin);

   return 0;
}

int 
yyerror(const char * msg) 
{
   printf("%d: %s at '%s'\n", yylineno, msg, yytext);
}

int
yywrap()
{
}
