%{
/**
 *
 * Test parser for the qP+ grammer.
 *
 * Author: Matthew W. Coan
 * Sun Feb  9 15:29:34 EST 2003
 */

#include <cstdio>
#include <string>
#include <vector>
#include <map>
#include <iostream>
#include <fstream>

using namespace std;

typedef vector< string > string_vector_type;
typedef map< string, string > string_map_type;

string_map_type type_map;

string_vector_type * id_vector = 0;
extern string prog_name;

extern int yylex();
extern int yyerror(const char * msg);
extern string get_class_name(const string & file_name);
const char * op = NULL;
int label = 0;
int my_count = 0;
string the_type;
string end_label;
string start_label;

bool is_global(const char * str) {
   bool ret = false;
   return ret;
}

bool is_number(const char * str) {
   bool ret = false;
   if(isdigit(str[0]))
      ret = true;
   return ret;
}

bool is_string(const char * str) {
   bool ret = false;
   if(str[0] == '\"')
      ret = true;
   return ret;
}

string get_next_label() {
   string ret;

   char buffer[100];

   memset(buffer, 0, 100);

   sprintf(buffer, "L%d", label);

   label++;

   ret = buffer;

   return ret;
}

typedef vector< string > const_vector_type;

const_vector_type const_vec;

class instruction {
public:
   string op;
   string arg1;
   string arg2;
   string label;

   instruction() { 

   }

   instruction(const instruction & c) {
      op = c.op;
      arg1 = c.arg1;
      arg2 = c.arg2;
      label = c.label;
   }

   ~instruction() {

   }

   instruction & operator=(const instruction & inst) {
      op = inst.op;
      arg1 = inst.arg1;
      arg2 = inst.arg2;
      label = inst.label;
      return *this;
   }
};

typedef vector< instruction > instruction_vector_type;

instruction_vector_type code;

void
add_instruction(const string & label)
{
   instruction inst;
   inst.label = label;
   code.push_back(inst);
}

void
add_instruction(const string & op,
     const string & arg1)
{
   instruction inst;
   inst.op = op;
   inst.arg1 = arg1;
   code.push_back(inst);
}

void
add_instruction(const string & op,
     const string & arg1, 
     const string & arg2)
{
   instruction inst;
   inst.op = op;
   inst.arg1 = arg1;
   inst.arg2 = arg2;
   code.push_back(inst);
}
     
void
emit()
{
   fstream fout(prog_name.c_str(), ios::out | ios::trunc);
   if(fout) {
      fout << ".class " << get_class_name(prog_name) << endl << flush;
      fout << ".access public" << endl << endl << flush;
      fout << ".modifyers" << endl << endl << flush;
      fout << ".extends java.lang.Object" << endl << flush;
      fout << ".implements" << endl << endl << flush;

      fout << ".method main" << endl << flush;
      fout << ".maxStack 5" << endl << flush;
      fout << ".access public" << endl << flush;
      fout << ".modifyers static" << endl << flush;
      fout << ".signature ([Ljava/lang/String;)V" << endl << flush;
      fout << ".args args" << endl << endl << flush;

      for(size_t i = 0; i < code.size(); i++) {
         if(code[i].arg1 != "" && code[i].arg2 != "") {
            fout << "\t" << code[i].op << " " << code[i].arg1 << "," << code[i].arg2 << endl << flush;
         }
         else if(code[i].arg1 != "" && code[i].op != "") {
            fout << "\t" << code[i].op << " " << code[i].arg1 << endl << flush;
         }
         else if(code[i].arg1 == "" && code[i].arg2 == "" && code[i].op != "") {
            fout << "\t" << code[i].op << endl << flush;
         }
         else if(code[i].label == ".code") {
            fout << endl << ".code" << endl << flush;
         }
         else if(code[i].label == ".end") {
            fout << ".end" << endl << endl << flush;
         }
         else if(code[i].label == ".data") {
            fout << ".data" << endl << endl << flush;
         }
         else if(code[i].label != "") {
            if(code[i].label[0] == 'L') {
               fout << code[i].label << " " << flush;
            }
            else {
               fout << "\t" << code[i].label << " " << endl << flush;
            }
         }

         if(code[i].label == ".end") {
            fout << endl << flush;
         }
      }
      fout.close();
   }
}

%}

%union {
   const char * sval;
}


%token QP_MAIN
%token QP_DO
%token QP_VAR
%token QP_NEW
%token QP_READ
%token QP_WRITE
%token QP_IF
%token QP_WHILE
%token QP_STRING_NAME
%token QP_CHAR_NAME
%token QP_INT_NAME
%token QP_BOOLEAN_NAME
%token QP_TRUE
%token QP_FALSE
%token QP_NOT
%token QP_GTEQ
%token QP_LTEQ
%token QP_EQ
%token QP_NEQ
%token <sval> QP_NAME
%token <sval> QP_STRING
%token <sval> QP_CHAR
%token <sval> QP_INT
%token <sval> QP_BOOLEAN
%left '-' '+'
%left '*' '/'

%type <sval> expression
%type <sval> lefthandside
%type <sval> righthandside
%type <sval> simple_expression
%type <sval> term
%type <sval> factor

%%

start: QP_MAIN QP_NAME '(' identifier_list ')' ';'  
       {
          add_instruction(".data");
       }
       declarations 
       {
          add_instruction(".code");
       }
       compound_statement 
       '$'
       {
         add_instruction("return");
         add_instruction(".end");

         emit();
      }
   ;

identifier_list: QP_NAME  { id_vector->push_back(string($1)); }
   | identifier_list ',' QP_NAME { id_vector->push_back(string($3)); }
   ;

declarations: declarations QP_VAR identifier_list ':' type ';' 
   {
      char buffer[1024];
      for(size_t i = 0; i < id_vector->size(); i++) {
         my_count += 4;

         type_map[(*id_vector)[i]] = the_type;

         sprintf(buffer, "%s %s", the_type.c_str(), (*id_vector)[i].c_str());

         add_instruction(buffer);
      }

      id_vector->clear();
   }
   | 
   { }
   ;

type: standard_type | QP_STRING_NAME { the_type = "String"; }
   ;

standard_type: QP_CHAR_NAME { the_type = "char"; } 
               | QP_INT_NAME { the_type = "int"; }
               | QP_BOOLEAN_NAME { the_type = "boolean"; }
   { }
   ;

compound_statement: '{' optional_statements '}'
   { 
   } 
   ;

optional_statements: statement_list | object ';' optional_statements |
   { }
   ;

object: QP_NAME '=' QP_NEW QP_STRING_NAME '[' size ']'
   { }
   ;

statement_list: statement 
      | statement_list ';' statement
   { }
   ;

statement: lefthandside
      | compound_statement
      | QP_READ '(' QP_NAME ')' {
         add_instruction("invokestatic io read_int ()I");
         add_instruction("istore", string($3));
      }
      | QP_WRITE '(' QP_NAME ')' {
         if(type_map[$3] == "int") {
            if(is_number($3))
               add_instruction("ipush", string($3));
            else
               add_instruction("iload", string($3));
            add_instruction("invokestatic io write_int (I)V");
         }
         else if(type_map[$3] == "String") {
            if(is_string($3)) 
               add_instruction("spush", string($3));
            else
               add_instruction("aload", string($3));
            add_instruction("invokestatic io write_string (Ljava/lang/String;)V");
         }
      }
      | QP_IF '(' expression ')' { 
         end_label = (get_next_label()); 
         add_instruction("ipush", "0"); 
         add_instruction("if_icmpeq", end_label); } 
      statement { 
         add_instruction(end_label);
      }
      | QP_WHILE '(' 
      {
         start_label = (get_next_label()); 
         add_instruction(start_label);
      }
      expression ')' QP_DO 
      {
         end_label = (get_next_label()); 
         add_instruction("ipush", "0"); 
         add_instruction("if_icmpeq", end_label);
      }
      statement
      {
         add_instruction("goto", start_label);
         add_instruction(end_label);
      }
   { }
   ;

lefthandside: QP_NAME '=' righthandside
   { 
      if(type_map[$1] == "int")
         add_instruction("istore", $1); 
      else if(type_map[$1] == "String") 
         add_instruction("astore", $1); 
      else if(type_map[$1] == "boolean") 
         add_instruction("istore", $1); 
   }
   ;

righthandside: expression 
      | QP_STRING { 
           add_instruction("spush", $1); 
        }
      | casting expression
   { }
   ;

casting: standard_type simple_expression
   { }
   ;

expression: simple_expression
      | simple_expression relop simple_expression 
        { 
/*
add_instruction(string("invokestatic qp_math ") + string(op) + string(" (II)I"));
*/
           string label = get_next_label();
           string label2 = get_next_label();
           add_instruction(op, label);
           add_instruction("ipush", "0");
           add_instruction("goto", label2);
           add_instruction(label);
           add_instruction("ipush", "1");
           add_instruction(label2);
        }
   { }
   ;

simple_expression: term
      | simple_expression addop term  { add_instruction(op, ""); }
   { }
   ;

term: factor
      | term mulop factor { add_instruction(op, ""); }
   { }
   ;

factor: QP_NAME 
      { 
         if(is_global($1)) {
            if(is_number($1)) 
               add_instruction("ipush", string($1)); 
            else 
               add_instruction("iload", string($1)); 
         }
         else {
            if(is_number($1))
               add_instruction("ipush", string($1)); 
            else
               add_instruction("iload", string($1)); 
         }
      }
      | QP_INT { 
         add_instruction("ipush", $1); 
        }
      | QP_TRUE { add_instruction("ipush", "1"); }
      | QP_FALSE { add_instruction("ipush", "0"); }
      | QP_NOT factor { add_instruction("not"); }
   { }
   ;

size: QP_INT
   { }
   ;

relop: '>' { op = "if_icmpgt"; }
      | QP_GTEQ { op = "if_icmpgteq"; }
      | QP_EQ { op = "if_icmpeq"; }
      | QP_LTEQ { op = "if_icmplteq"; }
      | '<' { op = "if_icmplt"; }
      | QP_NEQ { op = "if_icmpneq"; }
   { }
   ;

addop: '+' { op = "iadd"; } 
      | '-' { op = "isub"; }
   { }
   ;

mulop: '*'  { op = "imul"; }
      | '/' { op = "idiv"; }
      | '%' { op = "imod"; }
   { }
   ;

%%
