/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.mac;

import cryptix.CryptixException;
import cryptix.util.core.Debug;
import cryptix.util.core.Hex;
import java.io.PrintWriter;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import xjava.security.Parameterized;

public class HMAC
extends MessageDigest
implements Parameterized,
Cloneable {
    private static final boolean DEBUG = true;
    private static final int debuglevel = Debug.getLevel("HMAC");
    private static final PrintWriter err = Debug.getOutput();
    private MessageDigest md;
    private int blockSize;
    private int length;
    private byte[] key;

    private static void debug(String string) {
        err.println("HMAC: " + string);
    }

    public Object clone() throws CloneNotSupportedException {
        return new HMAC(this);
    }

    protected void engineReset() {
        this.md.reset();
        this.key = null;
    }

    protected void engineUpdate(byte by) {
        if (this.key == null) {
            throw new IllegalStateException(this.getAlgorithm() + ": Key has not been set");
        }
        this.md.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        if (this.key == null) {
            throw new IllegalStateException(this.getAlgorithm() + ": Key has not been set");
        }
        this.md.update(byArray, n, n2);
    }

    protected byte[] engineDigest() {
        if (debuglevel >= 7) {
            HMAC.debug("engineDigest()");
        }
        if (this.key == null) {
            throw new IllegalStateException(this.getAlgorithm() + ": Key has not been set");
        }
        byte[] byArray = this.md.digest();
        byte[] byArray2 = new byte[this.blockSize];
        int n = 0;
        while (n < this.key.length) {
            byArray2[n] = (byte)(0x5C ^ this.key[n]);
            ++n;
        }
        n = this.key.length;
        while (n < this.blockSize) {
            byArray2[n] = 92;
            ++n;
        }
        this.md.update(byArray2);
        byte[] byArray3 = this.md.digest(byArray);
        if (debuglevel >= 7) {
            HMAC.debug("... = <" + Hex.toString(byArray3) + ">");
        }
        return byArray3;
    }

    protected int engineGetDigestLength() {
        return this.length;
    }

    public void setParameter(String string, Object object) throws InvalidParameterException {
        this.engineSetParameter(string, object);
    }

    public Object getParameter(String string) throws InvalidParameterException {
        return this.engineGetParameter(string);
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        try {
            if (string.equalsIgnoreCase("key")) {
                this.setKey((byte[])object);
                return;
            }
            if (this.key != null) {
                throw new InvalidParameterException(this.getAlgorithm() + ": Can't set parameter after key has been initialised");
            }
            ((Parameterized)((Object)this.md)).setParameter(string, object);
        }
        catch (Exception exception) {
            throw new InvalidParameterException(exception.getMessage());
        }
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        try {
            return ((Parameterized)((Object)this.md)).getParameter(string);
        }
        catch (Exception exception) {
            throw new InvalidParameterException(exception.getMessage());
        }
    }

    private void setKey(byte[] byArray) {
        if (debuglevel >= 7) {
            HMAC.debug("setKey(<" + Hex.toString(byArray) + ">)");
        }
        if (this.key != null) {
            this.md.reset();
        }
        this.key = byArray.length > this.blockSize ? this.md.digest(byArray) : (byte[])byArray.clone();
        byte[] byArray2 = new byte[this.blockSize];
        int n = 0;
        while (n < this.key.length) {
            byArray2[n] = (byte)(0x36 ^ this.key[n]);
            ++n;
        }
        n = this.key.length;
        while (n < this.blockSize) {
            byArray2[n] = 54;
            ++n;
        }
        this.md.update(byArray2);
    }

    public HMAC(String string, int n) {
        super("HMAC-" + string);
        try {
            this.md = MessageDigest.getInstance(string, "Cryptix");
        }
        catch (Exception exception) {
            try {
                this.md = MessageDigest.getInstance(string);
            }
            catch (Exception exception2) {
                throw new CryptixException(this.getAlgorithm() + ": Unable to instantiate the " + string + " MessageDigest\n" + exception2);
            }
        }
        this.blockSize = n;
        this.length = this.md.digest().length;
        this.key = new byte[n];
    }

    private HMAC(HMAC hMAC) throws CloneNotSupportedException {
        super(hMAC.getAlgorithm());
        this.md = (MessageDigest)hMAC.md.clone();
        this.blockSize = hMAC.blockSize;
        this.length = hMAC.length;
        byte[] byArray = hMAC.key;
        this.key = byArray == null ? null : (byte[])byArray.clone();
    }
}

