#ifndef CSVFILE_H
#define CSVFILE_H

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

/**
 * ANSI C implementation of a CSV File Reader.
 *
 * Matthew W. Coan (04/22/2002) Orases Corp.
 */

/*************************
 * The column name 2 index 
 * structure.
 */
typedef struct _CSVFileReaderColName {

   char * name;
   size_t index;

} CSVFileReaderColName;

/*************************
 * The CSV File structure.
 */
 typedef struct _CSVFileReader {
    
    FILE * file;
    CSVFileReaderColName ** colNameArray;
    char ** colValueArray;
    size_t numCols;
    
 } CSVFileReader;

/* Create a CSVFileReader. This function returns NULL if an error occurs. */
CSVFileReader * CSVFileReaderCreate(char * fileName);

/* Destory a CSVFileReader. */
void CSVFileReaderDestroy(CSVFileReader * pReader);

/* Read the next line of the CSV file.  
   Return number of columns in the line 
   else 0 if EOF or error in read. */
int CSVFileReaderReadLine(CSVFileReader * pReader);

/* Get a value associated with a column name for the current line. */
char * CSVFileReaderGetValue(CSVFileReader * pReader, char * colName);

#endif /* CSVFILE_H */


