/*

DLL file class for Windows, Linux and BSD.

Author: Matthew William Coan
Date: Fri Jan  7 20:50:58 EST 2011

*/

#ifndef _DLL_FILE_H
#define _DLL_FILE_H

#include <string>

#include <dlfun.h>

using namespace std;

class dll_file {
   void * _pointer;

public:
   dll_file(const char * str) {
      _pointer = dlopen(str, RTDL_LAZY);
   }

   ~dll_file() {
      if(_pointer) {
         dlclose(_pointer);
      }
   }

   operator void*() {
      return _pointer;
   }

   void * get_symbol(const char * symbol) {
      return dlsym(_pointer, symbol);
   }
};

#endif /* _DLL_FILE_H */
