#include <iostream>
#include <iomanip>
#include <cstdio>
#include "simple_eval.h"

string
read_line(istream & in)
{
    string ret;
    char ch = in.get();
    while(in) {
       if(ch == '\n') break;
       ret += ch;
       ch = in.get(); 
    }
    return ret;
}

int
main()
{
   string buffer;
   string str;
   var result;
   SimpleEval the_eval;
   cout << "SIMPLE C++ EXPRESSION EVALUATOR..." << endl << endl;
   cout << "Author: Matt Coan (matthewcoan1976@hotmail.com)" << endl;
   cout << "Compiled on: " << __DATE__ << " " << __TIME__ << endl << endl;
   cout << "Please type \"exit\" or \"quit\" to end this program..." << endl;
   cout << endl;
   while(true) {
      cout << "expr> ";
      buffer = read_line(cin); 
      str = buffer;
      str = trim(str);
      if(strcasecmp(str.c_str(), "exit") == 0
         || strcasecmp(str.c_str(), "quit") == 0) {
         break;
      }
      result = the_eval.eval(buffer);
      cout << fixed << setprecision(8) << result << endl;
   }
   return 0;
}
