#ifndef _SQL_H
#define _SQL_H

/*

Copyright (C) 2009, All rights reserved.  
This source is the intellectual proprety of Matthew William Coan.

Small C++ SQL database client API.

Author: Matthew William Coan
Date: Sun May 22 14:55:18 EST 2011

*/

#include <mysql.h>
#include <string>

namespace sql_tools {

using namespace std;

class Statement;

class Connection {
   string host;
   int port;
   MYSQL * conn;
   int error_code;

public:
   Connection(const string & host,
              const string & user,
              const string & pass,
              const string & db)
   {
      this->host = host;

      conn = mysql_init(NULL);

      if(!mysql_real_connect(conn, host.c_str(), user.c_str(), pass.c_str(), db.c_str(), 0, NULL, 0))
         error_code = 0;
      else
         error_code = 1;
   }

   virtual ~Connection()
   {
      if(conn != NULL)
         mysql_close(conn);
   }

   Statement * get_statement();

   void set_catalog(const string & db) { mysql_select_db(conn, db.c_str()); }

   operator int() { return error_code; }
};

class ResultSet;

class Statement {
   MYSQL * conn;

public:
   Statement(MYSQL * conn)
   {
      this->conn = conn;
   }

   ~Statement()
   {
   }
   
   ResultSet * execute(const string & sql);

   bool execute_update(const string & sql)
   {   
       bool ret = true;

       if(mysql_query(conn, sql.c_str()))
           ret = false;

       return ret;
   }
};

class ResultSet {
   MYSQL_RES * res;
   MYSQL_ROW row;

public:
   ResultSet(MYSQL_RES * res)
   {
      this->res = res;
      row = mysql_fetch_row(res);
   }

   ~ResultSet()
   {
      mysql_free_result(res);
   }

   string get_string(const size_t index)
   {
      return row[index];
   }

   string get_string(const string & name)
   {
      string ret;

      return ret;
   }

   void next()
   { 
      row = mysql_fetch_row(res);
   }

   bool has_more()
   { 
       bool ret = false;

       if(row) 
          ret = true;

       return ret;
   }
};

inline ResultSet * Statement::execute(const string & sql)
{
   MYSQL_RES * res = NULL;
   ResultSet * ret = 0;

   if(!mysql_query(conn, sql.c_str())) {
      res = mysql_use_result(conn);

      ret = new ResultSet(res);
   }

   return ret;
}

inline Statement * Connection::get_statement()
{
   return new Statement(conn);
}


}



#endif /* _SQL_H */
