#ifndef _MATT_STL_STACK
#define _MATT_STL_STACK

#include "list"

namespace std {

template< class T >
class stack {
   list< T > stk;

public:
   stack() { }
   stack(const stack< T > & cp) { stk = cp.stk; }
   ~stack() { }
   const T & top() { 
      assert(stk.size() != 0);
      return stk.front(); 
   }
   void pop() { assert(stk.size() != 0); stk.pop_front(); }
   void push(const T & t) { stk.push_front(t); }
   size_t size() { return stk.size(); }
   size_t size() const { return stk.size(); }
   stack< T > & operator=(const stack< T > & st) {
      this->stk = st.stk;
      return *this;
   }
};

}

#endif
