#ifndef _STR_BUF_H
#define _STR_BUF_H

#include <iostream>
#include <string>
#include <list>

using namespace std;

class string_buffer {
public:
   typedef list< string > buffer_type;
   enum { BUFFER_SIZE = 1024 };

private:
   buffer_type _buffer;
   char _char_buffer[BUFFER_SIZE];

public:
   string_buffer() { }
   string_buffer(const string_buffer & cp) { }

   virtual ~string_buffer() { }

   string_buffer & operator=(const string_buffer & right) {
      _buffer = right._buffer;
      return *this;
   }

   void append(const char * str) {
      _buffer.push_back(string(str));
   }

   void append(const string & str) {
      _buffer.push_back(str);
   }

   void append(const long & data) {
      string str;
      memset(_char_buffer, 0, BUFFER_SIZE);
      sprintf(_char_buffer, "%li", data);
      str = string(_char_buffer);
      _buffer.push_back(str);
   }

   void append(const unsigned long & data) {
      string str;
      memset(_char_buffer, 0, BUFFER_SIZE);
      sprintf(_char_buffer, "%lui", data);
      str = string(_char_buffer);
      _buffer.push_back(str);
   }

   void append(const double & data) {
      string str;
      memset(_char_buffer, 0, BUFFER_SIZE);
      sprintf(_char_buffer, "%lf", data);
      str = string(_char_buffer);
      _buffer.push_back(str);
   }
 
   void append(const float & data) {
      string str;
      memset(_char_buffer, 0, BUFFER_SIZE);
      sprintf(_char_buffer, "%f", data);
      str = string(_char_buffer);
      _buffer.push_back(str);
   }

   void append(const int & data) {
      string str;
      memset(_char_buffer, 0, BUFFER_SIZE);
      sprintf(_char_buffer, "%d", data);
      str = string(_char_buffer);
      _buffer.push_back(str);
   }

   void append(const unsigned int & data) {
      string str;
      memset(_char_buffer, 0, BUFFER_SIZE);
      sprintf(_char_buffer, "%ud", data);
      str = string(_char_buffer);
      _buffer.push_back(str);
   }

   void append(const short & data) {
      string str;
      memset(_char_buffer, 0, BUFFER_SIZE);
      sprintf(_char_buffer, "%d", static_cast< int >(data));
      str = string(_char_buffer);
      _buffer.push_back(str);
   }

   void append(const unsigned short & data) {
      string str;
      memset(_char_buffer, 0, BUFFER_SIZE);
      sprintf(_char_buffer, "%d", static_cast< int >(data));
      str = string(_char_buffer);
      _buffer.push_back(str);
   }

   void append(const char & data) {
      string str;
      memset(_char_buffer, 0, BUFFER_SIZE);
      sprintf(_char_buffer, "%c", data);
      str = string(_char_buffer);
      _buffer.push_back(str);
   }

   void append(const unsigned char & data) {
      string str;
      memset(_char_buffer, 0, BUFFER_SIZE);
      sprintf(_char_buffer, "%uc", data);
      str = string(_char_buffer);
      _buffer.push_back(str);
   }

   string to_string() const {
      string ret;

      for(buffer_type::const_iterator p = _buffer.begin(); p != _buffer.end(); 
          p++) {
         ret += (*p);
      }

      return ret;
   }

   operator string() const {
      return to_string();
   }
};

ostream & operator<<(ostream & out, const string_buffer & sb) 
{
   out << sb.to_string();
   return out;   
}

#endif /* _STR_BUF_H */
