#ifndef _TCP_SERVER_H
#define _TCP_SERVER_H
/*

tcp_server class.

Author: Matthew William Coan
Date: Tue Jul 27 15:44:40 EDT 2010

*/

#define OS_WINDOWS

/*
#ifdef OS_UNIX
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#endif

#ifdef OS_WINDOWS
*/
#include <windows.h>
#include <winsock.h>
//#endif

#include <cstring>
#include <string>

#ifdef OS_UNIX
#define closesocket(a) close(a)
#define SOCKET int
#endif

namespace net_tools {

using namespace std;

class tcp_server {
   string _ip_address;
   const int _port;
   sockaddr_in _svr, _cli;
   SOCKET _fd, _client_fd;
   bool _err;

public:
   tcp_server(const string & ip_address, 
              const int port);
   ~tcp_server();

   SOCKET accept();
   void close();

   operator void*() {
      return (void*)!_err;
   }

   bool get_error() {
      return _err;
   }
};

}

#endif /* _TCP_SERVER_H */

