/*

var.h -- test program.

Author: Matthew W. Coan
Date: Thu Jun  7 21:43:30 EDT 2018

*/

#include <iostream>
#include <string>
#include <cstdio>
#include "var.h"

using namespace std;
using namespace string_tools;

class Person {
   var name;
   var age;
public:
   Person() {
   }
   Person(const var & n, const var & a) {
      cout << "Person(" << n << "," << a << ")" << endl;
      name = n;
      age = a;
   }
   Person(const Person & person) 
   : name(person.name), age(person.age) {
   }
   ~Person() {
      cout << "Person::~Person()" << endl;
   }
   Person & operator=(const Person & right) {
      name = right.name;
      age = right.age;
      return *this;    
   }
   void print() {
      cout << "Name: " << name << endl;
      cout << "Age: " << age << endl;
   }
};

void print(var & v)
{
   ((Person*)v)->print();
}

typedef int (*pf_t)(const char * fmt, ...);

int
main(int argc,
     char ** argv)
{
   var v1 = "HELLO";
   var v2 = 12345;
   v2++;
   var v3 = v1 + v2;
   cout << "v1 = " << v1 << endl; 
   cout << "v2 = " << v2 << endl; 
   cout << "v3 = " << v3 << endl; 
   var v4 = "12344";
   v4++;
   cout << "v4 = " << v4 << endl;
   var array(VAR_DATA::ARRAY_TYPE);
   var n = 10;
   for(var i = 0; i < n; i++)
      array[i] = i + n;
   for(var i = 0; i < n; i++)
      cout << array[i] << endl;
   for(var::iterator i = array.begin(); i != array.end(); i++)
      cout << i->first << " -> " << i->second << endl;
   var the_fun((void*)printf, VAR_DATA::INT_TYPE);
   var count = the_fun("HELLO WORLD C=%d\n", 123);
   cout << "count=" << count << endl;
   t_var< Person > obj = new Person("MATTHEW COAN", 42);
   obj->print();
   print(obj);
   return 0;
}
