#include <iostream>
#include <fstream>
#include <string>
#include <sstream>
#include "detect_hacking.h"
#include "md5.h"

#ifdef WINDOWS_OS
#include <windows.h>
#endif

using namespace std;
using namespace security_tools;

extern char HACKING_CODE[];

char HACKING_CODE[]  = "$start$00000000000000000000000000000000$end$";

void
security_tools::detect_hacking() throw(hacking_exception)
{
   string hash,the_name;

#ifdef UNIX_OS
   the_name = getprogname() + string(".md5");
   if(!compute_md5(getprogname(), hash)) {
      throw hacking_exception();
   }
#endif

#ifdef WINDOWS_OS
   TCHAR name[MAX_PATH + 1];
   memset(name, 0, MAX_PATH);
   GetModuleFileName(NULL, name, MAX_PATH);
   the_name = (char*)name;
   if(!compute_md5(name, hash)) {
      throw hacking_exception();
   }
#endif

   string md5;
   for(size_t i = 7; HACKING_CODE[i]; i++) {
      if(memcmp(&HACKING_CODE[i], "$end$", 5) == 0) {
         break;
      }
      else {
         md5 += HACKING_CODE[i]; 
      }
   }
 
/*
   string md5;
   ifstream fin(the_name.c_str(), ios::in);
   if(fin) {
      fin >> md5;
      fin.close();
   }
   else {
      throw hacking_exception();
   }
*/

   if(hash != md5) {
      throw hacking_exception();
   }
}
