/*

DLL file class for Windows, Linux and BSD.

Author: Matthew William Coan
Date: Fri Jan  7 20:50:58 EST 2011

*/

#ifndef _DLL_FILE_H
#define _DLL_FILE_H

#include <string>
#include <windows.h>

using namespace std;

class dll_file {
   HINSTANCE _pointer;

public:
   dll_file(const char * str) {
      _pointer = LoadLibrary(str);
      if(_pointer == 0) {
         throw "DLL file not found...";
      }
   }

   ~dll_file() {
      if(_pointer) {
         CloseHandle(_pointer);
      }
   }

   void close() {
      if(_pointer) {
         CloseHandle(_pointer);
         _pointer = 0;
      }
   }

   operator void*() {
      return _pointer;
   }

   void* get_symbol(const char * symbol) {
      return (void*)GetProcAddress(_pointer, symbol);
   }
};

#endif /* _DLL_FILE_H */
