//
// Author: Matthew William Coan
// Date: 10/02/2022 10:09 AM
//
// Test program for diskstack template...
//
#include <iostream>
#include <fstream>
#include <string>
#include "diskstack.h"

using namespace std;
using namespace ds;

class Person {
   string name;
   int age;
public:
   Person() { 
      age = 0;
   }
   Person(const string & name, int age) {
      this->name = name;
      this->age = age;
   }
   Person & operator=(const Person & cp) {
      name = cp.name;
      age = cp.age;
      return *this;
   }
   const string & get_name() const { return name; }
   const int get_age() const { return age; }
   friend bfstream & operator<<(bfstream & out, const Person & cp);
   friend bfstream & operator>>(bfstream & in, Person & cp);
   friend ostream & operator<<(ostream & out, const Person & cp);
};

bfstream & operator<<(bfstream & out, const Person & cp) {
   out << cp.name << cp.age;
   return out;
}

bfstream & operator>>(bfstream & in, Person & cp) {
   in >> cp.name >> cp.age;
   return in;
}

ostream & operator<<(ostream & out, const Person & cp) {
   out << "Name: " << cp.name << " ";
   out << "Age: " << cp.age;
   return out;
}

int
main()
{
    try {
       diskstack< Person > stk("myfile.dat", CREATE_FILE); 
       Person val;
       for(auto i = 0; i < 0xFFFF; i++) {
          stk.push(Person("Matt",40+i));
       }
       while(stk.size()) {
          val = stk.pop();
          cout << val << endl;
       }
    }
    catch(const char* message) {
       cerr << message << endl;
    }
    return 0;
}
