#include <stdlib.h>
#include <limits.h>
#include "hashpjw.h"

#define SIZE_BITS 32

size_t
text_tools::hashpjw (const char *x, size_t tablesize)
{
  register const char *s;
  register size_t h = 0;

  for (s = x; *s; s++)
    h = *s + ((h << 9) | (h >> (SIZE_BITS - 9)));

  return h % tablesize;
}
