#include "disk_tools.h"
#include "d_hashmap.h"
#include "../io_tools/csv.h"
#include "../text_tools/hashpjw.h"
#include <iostream>
#include <algorithm>
#include <limits.h>

using namespace std;
using namespace io_tools;
using namespace disk_tools;
using namespace text_tools;

class string_hash {
public:
   offset_type operator()(const string & str) const {
      offset_type ret = 0L;
      ret = hashpjw(str.c_str(), 500029);
/*
      for(size_t i = 0; i < str.size(); i++) 
         ret += str[i] * i;
*/
      return LONG_MAX - ret;
   }
};

void tokenize(const string & str, vector< string > & vec) {
   char * buffer = new char[str.size()+1];
   strcpy(buffer, str.c_str());
   char * ptr = strtok(buffer, ",");
   while(ptr != NULL) {
      vec.push_back(ptr);
      ptr = strtok(NULL, ",");
   }
}

int
main()
{
   csv_row_type data;

   create_database("english");

   d_env env;

   p_d_env = & env;

   d_database * db = open_database("english");

   ifstream fin("definitions.csv", ios::in);
   {

   d_hashmap< string, string, string_hash > word_map("word_map", 500029);
   vector< string > vec;
   
   if(fin) {
      string temp;
      while(fin >> data) {
         if(data.size() >= 2) {
            temp = "";
            word_map.get(data[0], temp);
            vec.clear();
            tokenize(temp, vec);
            if(find(vec.begin(), vec.end(), data[1]) == vec.end()) {
               temp += "," + data[1];
               cout << data[0] << "=" << temp << endl;
               word_map.put(data[0], temp);
            }
         }
      }
      fin.close();
   }

   }
   close_database(db);

   return 0;
}
