// matt_win.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
// button_example.cpp : Defines the entry point for the application.
//

#include "thread.h"
#include "matt_win.h"
#include "chem_sim.h"
#include <windows.h>

using namespace matt_win;

#define IDC_MAIN_BUTTON	101
#define IDC_MAIN_OUTPUT	102
#define IDC_MAIN_INPUT	103

class MyApplication;

MyApplication * app = 0;

class MyApplication : public Application {
   Text * output;
   Text * input;
   Button * button;
   Frame * frame;
   element_map_type element_map;
   chemical_list_type chemical_list;

public:
   MyApplication(HINSTANCE hInst, int nShowCmd)
   { 
      app = this;
      frame = new Frame(hInst, nShowCmd, "Chemistry Simulator V1.0a");
	  p_text = output;
	  init_element_map(element_map);
	  help();
   }

   ~MyApplication() {
      if(output) delete output;
	  if(input) delete input;
      if(button) delete button;
      delete frame;
   }

   void on_create(HWND hWnd) {
      output = new Text(hWnd, "", IDC_MAIN_OUTPUT, 50, 200, 200, 50);
      input = new Text(hWnd, "", IDC_MAIN_INPUT, 50, 200, 200, 50);
      button = new Button(hWnd, "Enter", IDC_MAIN_BUTTON, 50, 250, 200, 50);
   }

   void resize(int w, int h) {
      int pad = 10;
      if(output) output->resize(w-pad-pad,h/2-pad-pad);
      if(output) output->move(pad,pad);
      if(input) input->resize(w/2-pad-pad,h/2-pad-pad);
	  if(input) input->move(pad, h/2+pad);
      if(button) button->resize(w-pad-pad-w/2,h/2-pad-pad);
      if(button) button->move((w/2)+pad, h/2+pad);
   }

   void on_command(WPARAM wParam) {
      if(LOWORD(wParam) == IDC_MAIN_BUTTON) {
         if(output && input) {
            string text = input->get_text();
			
			output->set_text("");
			
			//input->set_text("");

			winput << text;

			string choice;

			bool stop = false;

			while(winput >> choice) {
				process_menu_choice(chemical_list, 
								   choice, 
								   stop,
	       						   element_map);
			}
		 }
      }
   }

   void on_quit() {
      if(output) delete output;
      output = 0;
	  if(input) delete input;
	  input = 0;
      if(button) delete button;
      button = 0;
      PostQuitMessage(0);
   }
};

LRESULT CALLBACK WinProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam);

int WINAPI WinMain(HINSTANCE hInst,HINSTANCE hPrevInst,LPSTR lpCmdLine,int nShowCmd)
{
   try {
      MyApplication myApp(hInst, nShowCmd);
      myApp.run();
   }
   catch(...) {
      MessageBox(NULL, "Software Exception...",
      "Software Exception...", MB_OK);
   }
	return 0;
}

LRESULT CALLBACK WinProc(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	switch(msg)
	{
		case WM_CREATE:
		{
			if(app)
				app->on_create(hWnd);
		}
		break;

		case WM_COMMAND:
		{
			if(app)
				app->on_command(wParam);
		}	
		break;

		case WM_DESTROY:
		{
			if(app)
				app->on_quit();
			
		}
		break;


		case WM_SIZE:
		{
			int w = LOWORD(lParam);
			int h = HIWORD(lParam);
			if(app)
				app->resize(w, h);
		}
		break;
	}

	return DefWindowProc(hWnd,msg,wParam,lParam);
}