#include "ref.h"

inline
Ref::Ref() {
   ref = new REF();
   ref->ptr = new java::lang::Object();
   ref->count = 1;
}

inline
Ref::Ref(java::lang::Object * p) {
   ref = new REF();
   ref->ptr = p;
   ref->count++;
}

inline
Ref::Ref(const Ref & ref) {
   this->ref = ref.ref;
   this->ref->count++;
}

inline
Ref::~Ref() {
   ref->count--;
   if(ref->count == 0) {
      delete ref->ptr;
      delete ref;
   }
}

inline
Ref & Ref::operator=(const Ref & right) {
   ref->count--;
   if(ref->count == 0 && ref->ptr != right.ref->ptr) {
      delete ref->ptr;
      delete ref;
   }
   ref = right.ref;
   ref->count++;
   return *this;
}

inline
java::lang::Object * Ref::get_ptr() {
   return ref->ptr;
}
