#ifndef _RELOAD_H
#define _RELOAD_H

#include <string>
#include <cstdlib>

#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>

namespace Reload {

using namespace std;

#define CXX_COMPILER "/usr/bin/c++"

inline
void reload(const string & src,
            const string & exe) {
   signal(SIGCHLD, SIG_IGN);
   int pid;

   if((pid = fork()) == 0) {
      execlp(CXX_COMPILER, CXX_COMPILER, src.c_str(), "-o", exe.c_str(), NULL);
      cerr << "unable to re-compile..." << endl; 
   }
   else {
      int status = 0;
      waitpid(pid, &status, 0);
   }

   execlp(exe.c_str(), exe.c_str(), NULL);
   cerr << "unable to re-execute..." << endl;
}

}


#endif /* _RELOAD_H */
